/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.util.Hex;

public class FreeId
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)FreeId.class.getName());
    private int printId;
    private String description;
    private static final int PRINT_JOURNAL = 0;

    public FreeId(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    switch (fm.getFmState()) {
                        case 4: {
                            if (this.printId != 0) break;
                            fm.getParagon().addFinalItem(new ItemModel.Builder().setRow(-1).setDescription(this.description).setItemType(ItemModel.ItemType.printAnnouncement).build());
                            fm.getParagon().appendBinaryData(this.binary);
                            break;
                        }
                        default: {
                            if (this.printId != 0) break;
                            fm.getParagon().addItem(new ItemModel.Builder().setRow(-1).setDescription(this.description).setItemType(ItemModel.ItemType.printAnnouncement).build());
                            fm.getParagon().appendBinaryData(this.binary);
                        }
                    }
                    fm.saveDbParagon();
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block10: {
            block9: {
                FmFiscalMemory fm = this.eKasa.getFm();
                switch (fm.getFmState()) {
                    case 2: 
                    case 4: 
                    case 20: 
                    case 32: 
                    case 34: {
                        break;
                    }
                    default: {
                        return 52;
                    }
                }
                if (this.params.length != 2) {
                    return 32;
                }
                try {
                    this.printId = Integer.parseInt(this.params[1]);
                    if (this.printId >= 0 && this.printId <= 1) break block9;
                    return 96;
                }
                catch (NumberFormatException e) {
                    return 96;
                }
            }
            this.description = this.params[2];
            if (this.description.length() <= 40) break block10;
            return 33;
        }
        if (this.description.matches(".*[\\x00-\\x19].*")) {
            return 96;
        }
        return 0;
    }
}

