/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.db.enums.DB;
import sk.singularisdev.ekasask.fm.interfaces.DataGetInterface;
import sk.singularisdev.ekasask.fm.util.Hex;

public class GetJournalStructU
extends FmCommand
implements DataGetInterface {
    private static final Logger logger = LoggerManager.getLogger((String)GetJournalStructU.class.getName());
    private String receiptId;
    private DB type;
    private byte[] dataOut;
    private boolean atEnd = true;

    public GetJournalStructU(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                this.dataOut = fm.getJournalParagon(this.type, this.receiptId, "journal/" + ppekk.getId(), "paragon_" + this.receiptId);
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            if (e.getMessage().equals("java.sql.SQLException: No data")) {
                return 4;
            }
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 1) {
            return 32;
        }
        this.receiptId = this.params[0];
        switch (this.receiptId.length()) {
            case 44: {
                this.type = DB.okp;
                break;
            }
            case 34: {
                this.type = DB.uid;
                break;
            }
            case 11: {
                this.type = DB.pcd;
                break;
            }
            case 10: {
                this.type = DB.oldPcd;
            }
        }
        return 0;
    }

    @Override
    public void resetData() {
        this.atEnd = false;
    }

    @Override
    public byte[] getNextData() {
        byte[] data = this.dataOut;
        this.atEnd = true;
        return data;
    }

    @Override
    public boolean isAvailableData() {
        return !this.atEnd;
    }
}

