/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.util.ArrayList;
import java.util.Date;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.internal.GetCertificateInfo;
import sk.singularisdev.ekasask.command.internal.GetChduInfo;
import sk.singularisdev.ekasask.command.internal.GetChduSize;
import sk.singularisdev.ekasask.command.internal.GetIdentityInfo;
import sk.singularisdev.ekasask.command.internal.GetPrinterState;
import sk.singularisdev.ekasask.command.internal.UnsendedTransaction;
import sk.singularisdev.ekasask.fm.Constant;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.Turnover;
import sk.singularisdev.ekasask.fm.enums.VariableCodes;
import sk.singularisdev.ekasask.fm.interfaces.DataGetInterface;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.PrinterStatus;

public class GetVariable
extends FmCommand
implements DataGetInterface {
    private static final Logger logger = LoggerManager.getLogger((String)GetVariable.class.getName());
    private String variableCode;
    private byte[] dataOut;
    private boolean atEnd = true;

    public GetVariable(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    private String generateOutputData(PPEKK ppekk, FmFiscalMemory fm, String variableCode) throws EKasaException {
        try {
            Object[] data;
            VariableCodes code = VariableCodes.fromString(variableCode);
            Turnover vat = null;
            Date date = new Date();
            GetChduInfo getChdu = GetChduInfo.getInstance();
            GetChduSize getChduSize = GetChduSize.getInstance();
            GetIdentityInfo getInfo = GetIdentityInfo.getInstance((boolean)false);
            GetCertificateInfo getCert = GetCertificateInfo.getInstance((boolean)false);
            UnsendedTransaction unsent = UnsendedTransaction.getInstance((boolean)false, (boolean)false);
            GetPrinterState printerState = GetPrinterState.getInstance((boolean)true);
            switch (code) {
                case V_011: {
                    data = new Object[]{fm.getGT()};
                    break;
                }
                case V_121: 
                case V_122: 
                case V_123: 
                case V_124: 
                case V_125: {
                    vat = fm.getVat(code);
                    data = new Object[]{vat.getVat(), vat.getLocalTotal(), vat.getLocalVat(), vat.getLocalBase(), vat.getVatType() == null ? "INACTIVE" : vat.getVatType().name()};
                    break;
                }
                case V_131: 
                case V_132: 
                case V_133: 
                case V_134: 
                case V_135: {
                    vat = fm.getVat(code);
                    data = new Object[]{vat.getVat(), vat.getGlobalTotal(), vat.getGlobalVat(), vat.getGlobalBase(), vat.getVatType() == null ? "INACTIVE" : vat.getVatType().name()};
                    break;
                }
                case V_151: {
                    data = new Object[]{Constant.exchangeRate, fm.isVatPayer() ? 0 : 1, 0, 1, 0, 1, 0, fm.isSafeMode() ? 1 : 0};
                    break;
                }
                case V_161: {
                    data = new Object[]{0, 1, 1};
                    break;
                }
                case V_171: {
                    data = new Object[]{fm.getInvoiceTurnover(), fm.getinvoiceCounter()};
                    break;
                }
                case V_191: {
                    data = new Object[]{fm.getDcsrLocalPercentageCounter().getSurchargeItem(), fm.getDcsrLocalPercentageCounter().getSurchargeItemCounter(), fm.getDcsrLocalPercentageCounter().getDiscountItem(), fm.getDcsrLocalPercentageCounter().getDiscountItemCounter(), fm.getDcsrLocalPercentageCounter().getSurchargeSubtotal(), fm.getDcsrLocalPercentageCounter().getSurchargeSubtotalCounter(), fm.getDcsrLocalPercentageCounter().getDiscountSubtotal(), fm.getDcsrLocalPercentageCounter().getDiscountSubtotalCounter()};
                    break;
                }
                case V_192: {
                    data = new Object[]{fm.getDcsrGlobalPercentageCounter().getSurchargeItem(), fm.getDcsrGlobalPercentageCounter().getSurchargeItemCounter(), fm.getDcsrGlobalPercentageCounter().getDiscountItem(), fm.getDcsrGlobalPercentageCounter().getDiscountItemCounter(), fm.getDcsrGlobalPercentageCounter().getSurchargeSubtotal(), fm.getDcsrGlobalPercentageCounter().getSurchargeSubtotalCounter(), fm.getDcsrGlobalPercentageCounter().getDiscountSubtotal(), fm.getDcsrGlobalPercentageCounter().getDiscountSubtotalCounter()};
                    break;
                }
                case V_1A1: {
                    data = new Object[]{fm.getDcsrLocalValueCounter().getSurchargeItem(), fm.getDcsrLocalValueCounter().getSurchargeItemCounter(), fm.getDcsrLocalValueCounter().getDiscountItem(), fm.getDcsrLocalValueCounter().getDiscountItemCounter(), fm.getDcsrLocalValueCounter().getSurchargeSubtotal(), fm.getDcsrLocalValueCounter().getSurchargeSubtotalCounter(), fm.getDcsrLocalValueCounter().getDiscountSubtotal(), fm.getDcsrLocalValueCounter().getDiscountSubtotalCounter()};
                    break;
                }
                case V_1A2: {
                    data = new Object[]{fm.getDcsrGlobalValueCounter().getSurchargeItem(), fm.getDcsrGlobalValueCounter().getSurchargeItemCounter(), fm.getDcsrGlobalValueCounter().getDiscountItem(), fm.getDcsrGlobalValueCounter().getDiscountItemCounter(), fm.getDcsrGlobalValueCounter().getSurchargeSubtotal(), fm.getDcsrGlobalValueCounter().getSurchargeSubtotalCounter(), fm.getDcsrGlobalValueCounter().getDiscountSubtotal(), fm.getDcsrGlobalValueCounter().getDiscountSubtotalCounter()};
                    break;
                }
                case V_1B1: {
                    data = new Object[]{fm.getNegativeLocalCounter().getVoidValue(), fm.getNegativeLocalCounter().getVoidCount(), fm.getNegativeLocalCounter().getReturnValue(), fm.getNegativeLocalCounter().getReturnCount(), fm.getNegativeLocalCounter().getDestroyedValue(), fm.getNegativeLocalCounter().getDestroyedCount(), fm.getNegativeLocalCounter().getRoundValue(), fm.getNegativeLocalCounter().getRoundCount()};
                    break;
                }
                case V_1B2: {
                    data = new Object[]{fm.getNegativeGlobalCounter().getVoidValue(), fm.getNegativeGlobalCounter().getVoidCount(), fm.getNegativeGlobalCounter().getReturnValue(), fm.getNegativeGlobalCounter().getReturnCount(), fm.getNegativeGlobalCounter().getDestroyedValue(), fm.getNegativeGlobalCounter().getDestroyedCount(), fm.getNegativeGlobalCounter().getRoundValue(), fm.getNegativeGlobalCounter().getRoundCount()};
                    break;
                }
                case V_1C1: 
                case V_1C2: 
                case V_1C3: 
                case V_1C4: 
                case V_1C5: 
                case V_1C6: 
                case V_1C7: 
                case V_1C8: 
                case V_1CG: {
                    data = new Object[]{fm.getPaymentMethod(code).getGlobalDeposite(), fm.getPaymentMethod(code).getDepositeCount(), fm.getPaymentMethod(code).getGlobalWithdraw(), fm.getPaymentMethod(code).getWithdrawCount()};
                    break;
                }
                case V_1CH: {
                    data = new Object[]{fm.getDespositeWithdrawCount()};
                    break;
                }
                case V_1D1: {
                    data = new Object[]{fm.getNegativeLocalCounter().getNegativeValue(), fm.getNegativeLocalCounter().getNegativeCount(), fm.getLocalDiscountTotal(), fm.getLocalDiscountTotalCount(), 0, 0};
                    break;
                }
                case V_1D2: {
                    data = new Object[]{fm.getNegativeGlobalCounter().getNegativeValue(), fm.getNegativeGlobalCounter().getNegativeCount(), fm.getGlobalDiscountTotal(), fm.getGlobalDiscountTotalCount(), fm.getInvalidReceiptTotal(), fm.getInvalidReceiptCount()};
                    break;
                }
                case V_211: {
                    data = new Object[]{fm.getReceiptTotalNoVat(), fm.getReceiptTotalWithVat(), fm.getActualRow()};
                    break;
                }
                case V_B11: {
                    ppekk.process((AbstractCommand)getChdu);
                    ppekk.process((AbstractCommand)getChduSize);
                    data = new Object[]{getChdu.getResponse().getName(), getChdu.getResponse().getVersion(), getChdu.getResponse().getLastTransactionId(), getChduSize.getResponse().getStorageSize(), getChduSize.getResponse().getSectorSize(), getChduSize.getResponse().getDataStorageSize(), getChduSize.getResponse().getDataStorageFree(), getChduSize.getResponse().getKeyStorageSize(), getChduSize.getResponse().getKeyStorageFree(), getChduSize.getResponse().getInternalStorageSize(), getChduSize.getResponse().getInternalStorageFree()};
                    break;
                }
                case V_B21: {
                    ppekk.process((AbstractCommand)unsent);
                    data = new Object[]{unsent.getResponse().getUnsendedTransactionCount()};
                    break;
                }
                case V_B31: {
                    ppekk.process((AbstractCommand)getCert);
                    data = new Object[]{Formatter.get().generateStringDate("ddMMyyyy", getCert.getResponse().getValidTo())};
                    break;
                }
                case V_B41: {
                    data = new Object[]{fm.getReceiptNumberSFS(), fm.getUID(), fm.getOKP(), fm.getQR(), fm.getPKP(), fm.getTransactionId()};
                    break;
                }
                case V_B51: {
                    data = new Object[]{fm.getLastPPEKKError(), fm.getLastDbError(), fm.getLastSFSError()};
                    break;
                }
                case V_E11: {
                    data = new Object[]{fm.getReportNumber()};
                    break;
                }
                case V_E21: {
                    data = new Object[]{fm.getReceiptNumber(), fm.getReceiptNumberSFS()};
                    break;
                }
                case V_E31: {
                    ppekk.process((AbstractCommand)getChdu);
                    ppekk.process((AbstractCommand)getInfo);
                    data = new Object[]{getChdu.getResponse().getSn(), getInfo.getResponse().getIco(), getInfo.getResponse().getDic(), getInfo.getResponse().getCashRegisterCode(), getInfo.getResponse().getIcdph()};
                    break;
                }
                case V_E41: {
                    Integer[] ids;
                    ArrayList<Number> list = new ArrayList<Number>();
                    Integer[] integerArray = ids = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 16};
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Integer id = integerArray[n2];
                        list.add(id);
                        list.add(fm.getPaymentMethod(id).getMinCurrency());
                        list.add(fm.getPaymentMethod(id).isOverpay() ? 0 : 1);
                        ++n2;
                    }
                    data = list.toArray();
                    break;
                }
                case V_E71: 
                case V_E72: 
                case V_E73: 
                case V_E74: 
                case V_E75: 
                case V_E76: 
                case V_E77: 
                case V_E78: 
                case V_E7G: {
                    data = new Object[]{fm.getPaymentMethod(code).getName(), fm.getPaymentMethod(code).getMinCurrency(), fm.getPaymentMethod(code).isOverpay() ? 0 : 1, fm.getPaymentMethod(code).getGlobalTurnover(), fm.getPaymentMethod(code).getPaymentCount()};
                    break;
                }
                case V_E51: {
                    data = new Object[]{Formatter.get().generateStringDate("ddMMyyyy", date), Formatter.get().generateStringDate("HHmm", date)};
                    break;
                }
                case V_E52: {
                    data = new Object[]{Formatter.get().generateStringDate("ddMMyyyy", date), Formatter.get().generateStringDate("HHmmss", date)};
                    break;
                }
                case V_E61: {
                    data = new Object[]{"X"};
                    break;
                }
                case V_E81: {
                    int reportNumber = 0;
                    String dateDU = "01012000120000";
                    String dateShift = "01012000120000";
                    try {
                        reportNumber = fm.getReportNumber() - 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        dateDU = Formatter.get().generateStringDate("ddMMyyyHHmmss", fm.getLastReportDate());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        dateShift = Formatter.get().generateStringDate("ddMMyyyHHmmss", fm.getLastShiftDate());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    data = new Object[]{reportNumber, dateDU, 0, dateShift};
                    break;
                }
                case V_F11: {
                    data = new Object[]{0, 0, 0, fm.getActualRow(), fm.getFmState(), 1, 114};
                    break;
                }
                case V_F21: {
                    data = new Object[]{1, 100, 500, 500, 500, 50, 20, 2550, Formatter.get().generateStringDate("ddMMyyyHHmmss", new Date()), 0, 1};
                    break;
                }
                case V_F31: 
                case V_F32: 
                case V_F33: 
                case V_F34: 
                case V_F35: 
                case V_F36: {
                    data = new Object[]{fm.getHeader(code)};
                    break;
                }
                case V_F41: {
                    data = new Object[]{fm.getPrinterType(), fm.getPrinterBaud(), ppekk.getPrinter().getCharPerRow()};
                    break;
                }
                case V_F51: {
                    data = new Object[]{100000, 100000, 366};
                    break;
                }
                case V_F61: {
                    data = new Object[]{0};
                    break;
                }
                case V_F71: {
                    data = new Object[]{114, 14};
                    break;
                }
                case V_F81: {
                    data = new Object[]{0};
                    break;
                }
                case V_F91: {
                    data = new Object[]{0};
                    break;
                }
                case V_F92: {
                    ppekk.process((AbstractCommand)printerState);
                    PrinterStatus status = printerState.getResponse().getPrinterStatus();
                    data = new Object[]{status.isAutoCutterError(), status.isCoverOpen(), status.isEndOfPaper(), status.isOnline(), status.isPaperNearToEnd(), status.isPrinterResponseError()};
                    break;
                }
                default: {
                    data = new Object[]{"X"};
                }
            }
            return Formatter.get().generateVariableFormat(code, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(variableCode) + ";X";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        byte status;
        if (ppekk == null) {
            return -3;
        }
        try {
            if (!fm.isDbOk()) return -2;
            status = this.parseParams();
            if (status != 0) return status;
            try {
                this.dataOut = this.generateOutputData(ppekk, fm, this.variableCode).getBytes(Constant.CHARSET);
            }
            catch (EKasaException e) {
                fm.setLastPPEKKError(e.getErrorCode());
                e.printStackTrace();
                return -3;
            }
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
        return status;
    }

    @Override
    protected byte parseParams() {
        if (this.params.length != 1) {
            return 32;
        }
        this.variableCode = this.params[0];
        return 0;
    }

    @Override
    public void resetData() {
        this.atEnd = false;
    }

    @Override
    public byte[] getNextData() {
        byte[] data = this.dataOut;
        this.atEnd = true;
        return data;
    }

    @Override
    public boolean isAvailableData() {
        return !this.atEnd;
    }
}

