/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.io.IOException;
import java.net.Socket;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.client.server.Server;
import sk.singularisdev.ekasask.fm.Daemon;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.communication.AppDriverTcpIpClient;
import sk.singularisdev.ekasask.fm.util.Hex;

public class InternalCommand
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)InternalCommand.class.getName());
    private static final String SYSTRAY = "SYSTRAY";
    private String commandIdentification;

    public InternalCommand(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        if (fm.isDbOk()) {
            byte status = this.parseParams();
            if (status == 0 && this.commandIdentification.equals(SYSTRAY) && this.driver instanceof AppDriverTcpIpClient) {
                Socket socket = ((AppDriverTcpIpClient)this.driver).getSocket();
                ((AppDriverTcpIpClient)this.driver).stopDriver(true);
                Daemon.getInstance().getServerDriver().removeSocket(socket);
                try {
                    socket.setSoTimeout(0);
                    Server.forwardClientSocket((Socket)socket);
                }
                catch (IOException e) {
                    return -3;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        try {
            this.commandIdentification = this.params[0];
            if (this.commandIdentification.equals(SYSTRAY) && this.params.length != 1) {
                return 32;
            }
        }
        catch (NumberFormatException e) {
            return 96;
        }
        return 0;
    }
}

