/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.math.BigDecimal;
import java.math.RoundingMode;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.Checkers;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;

public class ItemDiscount
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)ItemDiscount.class.getName());
    private int row;
    private String description;
    private BigDecimal discountValue;
    private BigDecimal referencedValue;
    private BigDecimal realDiscountValue;
    private int operationType;
    private Character vat;

    public ItemDiscount(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (!fm.isDbOk()) {
                return -2;
            }
            byte status = this.parseParams();
            if (status == 0) {
                if (this.vat == null) {
                    ItemModel item = fm.getParagon().getLastValidItem();
                    if (item == null) {
                        return 52;
                    }
                    this.vat = Character.valueOf(item.getVat());
                    this.referencedValue = new BigDecimal(item.getTotalPrice());
                } else {
                    ItemModel item = fm.getParagon().getLastValidItem();
                    if (item == null) {
                        return 52;
                    }
                    if (this.vat.charValue() != item.getVat()) {
                        return 52;
                    }
                    this.referencedValue = new BigDecimal(item.getTotalPrice());
                }
                fm.beginTransaction();
                switch (this.operationType) {
                    case 0: {
                        this.realDiscountValue = this.discountValue;
                        if (this.referencedValue.compareTo(this.realDiscountValue) < 0) {
                            return 96;
                        }
                        fm.getVat(this.vat.charValue()).appendLocalTotal(this.realDiscountValue.negate());
                        fm.appendReceiptTotal(this.realDiscountValue.negate());
                        fm.getDcsrLocalValueCounter().appendDiscountItem(this.realDiscountValue);
                        break;
                    }
                    case 1: {
                        this.realDiscountValue = this.discountValue;
                        fm.getVat(this.vat.charValue()).appendLocalTotal(this.realDiscountValue);
                        fm.appendReceiptTotal(this.realDiscountValue);
                        fm.getDcsrLocalValueCounter().appendSurchargeItem(this.realDiscountValue);
                        break;
                    }
                    case 2: {
                        this.realDiscountValue = this.referencedValue.divide(new BigDecimal("100")).multiply(this.discountValue).setScale(2, RoundingMode.HALF_UP);
                        fm.getVat(this.vat.charValue()).appendLocalTotal(this.realDiscountValue.negate());
                        fm.appendReceiptTotal(this.realDiscountValue.negate());
                        fm.getDcsrLocalPercentageCounter().appendDiscountItem(this.realDiscountValue);
                        break;
                    }
                    case 3: {
                        this.realDiscountValue = this.referencedValue.divide(new BigDecimal("100")).multiply(this.discountValue).setScale(2, RoundingMode.HALF_UP);
                        fm.getVat(this.vat.charValue()).appendLocalTotal(this.realDiscountValue);
                        fm.appendReceiptTotal(this.realDiscountValue);
                        fm.getDcsrLocalPercentageCounter().appendSurchargeItem(this.realDiscountValue);
                        break;
                    }
                }
                fm.getParagon().addItem(new ItemModel.Builder().setRow(this.row).setDescription(this.description).setDiscountType(this.operationType).setDiscountValue(this.discountValue.toString()).setDiscountRealValue(this.realDiscountValue.toString()).setVat(this.vat.charValue()).setItemType(ItemModel.ItemType.itemDiscount).setPreline(fm.getPreline()).setPostline(fm.getPostline()).build());
                fm.getParagon().appendBinaryData(this.binary);
                fm.setPreline(null);
                fm.setPostline(null);
                fm.saveDbParagon();
                fm.setTransactionSuccesfull();
                fm.endTransaction();
            }
            return status;
        }
        catch (FmStoreToDbException e) {
            fm.endTransaction();
            logger.fatal("Database error", (Throwable)e);
            Function.initFMDB(fm);
            return -2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        PPEKK ppekk = this.eKasa.getPPEKK();
        if (fm.getFmState() != 2) {
            return 52;
        }
        if (this.params.length != 4 && this.params.length != 5) {
            return 32;
        }
        try {
            this.row = Integer.parseInt(this.params[0]);
            if (this.row < 0) return 96;
            if (this.row > 9) {
                return 96;
            }
            if (fm.isSafeMode() && fm.getActualRow() != this.row - 1) {
                return 67;
            }
            this.description = this.params[1];
            if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)false) > 18) {
                return 33;
            }
            if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)false) == 0) {
                return 33;
            }
            if (this.description.matches(".*[\\x00-\\x19].*")) {
                return 96;
            }
            this.description.replaceAll("\\*", " ");
            this.operationType = Integer.parseInt(this.params[2]);
            if (this.operationType < 0) return 96;
            if (this.operationType > 3) {
                return 96;
            }
            switch (this.operationType) {
                case 0: 
                case 1: {
                    if (Checkers.get().checkValueFormat(this.params[3], 7, 2)) break;
                    return 33;
                }
                case 2: 
                case 3: {
                    if (Checkers.get().checkValueFormat(this.params[3], 2, 2)) break;
                    return 33;
                }
            }
            if (this.params[3].contains("-")) {
                return 96;
            }
            this.discountValue = new BigDecimal(this.params[3]);
            if (this.params.length != 5) {
                this.vat = null;
                return 0;
            }
            if (this.params[4].length() > 1) {
                return 33;
            }
            this.vat = Character.valueOf(this.params[4].charAt(0));
            if (fm.validateVat(this.vat.charValue())) return 0;
            return 96;
        }
        catch (NumberFormatException e) {
            return 96;
        }
        catch (Exception e) {
            return 96;
        }
    }
}

