/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.math.BigDecimal;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.Checkers;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.enums.SFSError;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;

public class ItemVoid
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)ItemVoid.class.getName());
    private int row;
    private String description;
    private String units;
    private String referenceReceiptID;
    private BigDecimal totalPrice;
    private BigDecimal quantity;
    private BigDecimal unitPrice;
    private char vat;

    public ItemVoid(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    fm.beginTransaction();
                    fm.getVat(this.vat).appendLocalTotal(this.totalPrice.negate());
                    fm.appendReceiptTotal(this.totalPrice.negate());
                    fm.getNegativeLocalCounter().appendVoidValue(this.totalPrice);
                    fm.getParagon().addItem(new ItemModel.Builder().setRow(this.row).setDescription(this.description).setTotalPrice(this.totalPrice.toString()).setVat(this.vat).setUnitPrice(this.unitPrice.toString()).setQuantity(this.quantity.toString()).setUnits(this.units).setItemType(ItemModel.ItemType.itemVoid).setReferenceId(this.referenceReceiptID).setPreline(fm.getPreline()).setPostline(fm.getPostline()).build());
                    fm.getParagon().appendBinaryData(this.binary);
                    fm.setPreline(null);
                    fm.setPostline(null);
                    fm.saveDbParagon();
                    fm.setTransactionSuccesfull();
                    fm.endTransaction();
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            fm.endTransaction();
            logger.fatal("Database error", (Throwable)e);
            Function.initFMDB(fm);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block37: {
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    block30: {
                                        FmFiscalMemory fm;
                                        block29: {
                                            block28: {
                                                block27: {
                                                    block26: {
                                                        PPEKK ppekk;
                                                        block25: {
                                                            block24: {
                                                                block23: {
                                                                    fm = this.eKasa.getFm();
                                                                    ppekk = this.eKasa.getPPEKK();
                                                                    switch (fm.getFmState()) {
                                                                        case 2: {
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            return 52;
                                                                        }
                                                                    }
                                                                    if (this.params.length != 8) {
                                                                        return 32;
                                                                    }
                                                                    this.row = Integer.parseInt(this.params[0]);
                                                                    if (this.row >= 0 && this.row <= 9) break block23;
                                                                    return 96;
                                                                }
                                                                if (!fm.isSafeMode() || fm.getActualRow() == this.row - 1) break block24;
                                                                return 67;
                                                            }
                                                            this.description = this.params[1];
                                                            if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)false) <= fm.getCharCount()) break block25;
                                                            return 33;
                                                        }
                                                        if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)false) != 0) break block26;
                                                        return 33;
                                                    }
                                                    if (!this.description.matches(".*[\\x00-\\x19].*")) break block27;
                                                    return 96;
                                                }
                                                this.description.replaceAll("\\*", " ");
                                                if (Checkers.get().checkValueFormat(this.params[2], 6, 2)) break block28;
                                                return 33;
                                            }
                                            this.totalPrice = new BigDecimal(this.params[2]);
                                            if (this.params[3].length() <= 1) break block29;
                                            return 33;
                                        }
                                        this.vat = this.params[3].charAt(0);
                                        if (fm.validateVat(this.vat)) break block30;
                                        return 96;
                                    }
                                    if (Checkers.get().checkValueFormat(this.params[4], 5, 3)) break block31;
                                    return 33;
                                }
                                this.quantity = new BigDecimal(this.params[4]);
                                if (Checkers.get().checkValueFormat(this.params[5], 6, 5)) break block32;
                                return 33;
                            }
                            if (!this.params[5].contains("-")) break block33;
                            return 96;
                        }
                        if (this.params[5].length() <= 9) break block34;
                        return 96;
                    }
                    this.unitPrice = new BigDecimal(this.params[5]);
                    this.units = this.params[6];
                    if (this.units.length() <= 3) break block35;
                    return 33;
                }
                if (!this.units.matches(".*[\\x00-\\x19].*")) break block36;
                return 96;
            }
            this.units.replaceAll("\\*", " ");
            this.referenceReceiptID = this.params[7];
            if (this.referenceReceiptID.length() <= 44) break block37;
            return 33;
        }
        try {
            if (this.referenceReceiptID == null || this.referenceReceiptID.length() == 0) {
                return SFSError.SFS_ERROR_RETURN_OR_VOID_REFERENCED_ID_MANDATORY.getInternalFmInternalCode();
            }
        }
        catch (NumberFormatException e) {
            return 96;
        }
        catch (Exception e) {
            return 96;
        }
        return 0;
    }
}

