/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.util.Date;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.enums.ParagonType;
import sk.singularisdev.ekasask.fm.enums.SFSError;
import sk.singularisdev.ekasask.printer.utility.AbstractPrinterInterface;
import sk.singularisdev.ekasask.sfs.EKasaResponseException;

public class ParagonEnd
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)ParagonEnd.class.getName());
    private int rowNumber;
    private int graphicFooter;

    public ParagonEnd(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block9: {
            byte status;
            block10: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block9;
                    status = this.parseParams();
                    if (status != 0) break block10;
                    try {
                        if (fm.getParagon().getSaleType() == ParagonType.faktura && fm.getParagon().getInvoiceNumber() == null) {
                            return SFSError.SFS_ERROR_INVOICE_NUMBER_MANDATORY_FOR_INVOICE.getInternalFmInternalCode();
                        }
                        Date createdDate = new Date();
                        logger.info("[FMCOMMAND] DB Transaction started");
                        fm.beginTransaction();
                        fm.getParagon().setGraphicFooter(this.graphicFooter);
                        fm.getParagon().appendBinaryData(this.binary);
                        logger.info("[FMCOMMAND] GET PPEKK format receipt");
                        AbstractCommand ppekkCommand = fm.getParagon().getPPEKKFormat(fm, createdDate);
                        logger.info("[FMCOMMAND] JournalEntry create: start");
                        fm.createJournal(createdDate, ppekkCommand.getUUID());
                        logger.info("[FMCOMMAND] JournalEntry create: finished");
                        logger.info("[FMCOMMAND] ppekk process");
                        ppekk.process(ppekkCommand);
                        logger.info("[FMCOMMAND] JournalEntry confirmed");
                        fm.confirmJournal(ppekkCommand.getUUID());
                        fm.setTransactionSuccesfull();
                        fm.endTransaction();
                        logger.info("[FMCOMMAND] DB Transaction finished");
                        if (ppekk.getPrinter() instanceof AbstractPrinterInterface) {
                            AbstractPrinterInterface p = (AbstractPrinterInterface)ppekk.getPrinter();
                            p.setCharPerRow(p.getCharPerRowReceipt());
                            fm.setCharCount(p.getCharPerRowReceipt());
                        }
                    }
                    catch (EKasaResponseException e) {
                        fm.endTransaction();
                        Function.initFMDB(fm);
                        fm.setLastSFSError(e.getResponseCode());
                        fm.setLastPPEKKError(e.getErrorCode());
                        return SFSError.fromSFSCode(e.getResponseCode()).getInternalFmInternalCode();
                    }
                    catch (EKasaException e) {
                        fm.endTransaction();
                        Function.initFMDB(fm);
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    fm.endTransaction();
                    logger.fatal("Database error", (Throwable)e);
                    Function.initFMDB(fm);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        block10: {
            block9: {
                FmFiscalMemory fm = this.eKasa.getFm();
                switch (fm.getFmState()) {
                    case 4: 
                    case 10: 
                    case 20: 
                    case 34: {
                        break;
                    }
                    default: {
                        return 52;
                    }
                }
                if (this.params.length != 2) {
                    return 32;
                }
                try {
                    this.rowNumber = Integer.parseInt(this.params[0]);
                    if (this.rowNumber >= 0 && this.rowNumber <= 9) break block9;
                    return 96;
                }
                catch (NumberFormatException e) {
                    return 96;
                }
            }
            this.graphicFooter = Integer.parseInt(this.params[1]);
            if (this.graphicFooter >= 0 && this.graphicFooter <= 6) break block10;
            return 96;
        }
        if (!Formatter.get().isOSTimeZoneCorrect()) {
            return SFSError.SFS_ERROR_TIME_ZONE.getInternalFmInternalCode();
        }
        return 0;
    }
}

