/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.enumeration.SPECIAL_REGULATION;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.util.Hex;

public class Popis0DPH
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)Popis0DPH.class.getName());
    private int popisTyp;

    public Popis0DPH(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (!fm.isDbOk()) {
                return -2;
            }
            byte status = this.parseParams();
            if (status != 0) return status;
            ItemModel item = fm.getParagon().getLastValidPopis0Item();
            if (item == null || item.getPopis0DPH() != SPECIAL_REGULATION.NONE) return 52;
            if (fm.getVat(item.getVat()).getVat() != 0) {
                return 52;
            }
            switch (this.popisTyp) {
                case 0: {
                    item.setPopis0DPH(SPECIAL_REGULATION.PDP);
                    break;
                }
                case 1: {
                    item.setPopis0DPH(SPECIAL_REGULATION.OOD);
                    break;
                }
                case 2: {
                    item.setPopis0DPH(SPECIAL_REGULATION.CK);
                    break;
                }
                case 3: {
                    item.setPopis0DPH(SPECIAL_REGULATION.PT);
                    break;
                }
                case 4: {
                    item.setPopis0DPH(SPECIAL_REGULATION.UD);
                    break;
                }
                case 5: {
                    item.setPopis0DPH(SPECIAL_REGULATION.ZPS);
                }
            }
            fm.saveDbParagon();
            return status;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 2: 
            case 32: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 1) {
            return 32;
        }
        try {
            this.popisTyp = Integer.parseInt(this.params[0]);
            if (this.popisTyp < 0 || this.popisTyp > 5) {
                return 96;
            }
        }
        catch (NumberFormatException e) {
            return 96;
        }
        return 0;
    }
}

