/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.InternalDocument;
import sk.singularisdev.ekasask.command.ItemBarcode;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.enumeration.BARCODE_FONT_SIZE;
import sk.singularisdev.ekasask.enumeration.BARCODE_TEXT_POSITION;
import sk.singularisdev.ekasask.enumeration.BARCODE_TYPE;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.util.Hex;

public class PrintBC
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)PrintBC.class.getName());
    private int barcodeType;
    private String barcodeData;

    public PrintBC(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        BARCODE_TYPE type;
        byte status;
        block23: {
            try {
                if (!fm.isDbOk()) return -2;
                status = this.parseParams();
                if (status != 0) return status;
                switch (this.barcodeType) {
                    case 0: {
                        type = BARCODE_TYPE.UPC_A;
                        break;
                    }
                    case 1: {
                        type = BARCODE_TYPE.UPC_E;
                        break;
                    }
                    case 2: {
                        type = BARCODE_TYPE.EAN13;
                        break;
                    }
                    case 3: {
                        type = BARCODE_TYPE.EAN8;
                        break;
                    }
                    case 4: {
                        type = BARCODE_TYPE.CODE39;
                        break;
                    }
                    case 5: {
                        type = BARCODE_TYPE.ITF;
                        break;
                    }
                    case 6: {
                        type = BARCODE_TYPE.CODABAR;
                        break;
                    }
                    case 65: {
                        type = BARCODE_TYPE.UPC_Ax;
                        break;
                    }
                    case 66: {
                        type = BARCODE_TYPE.UPC_Ex;
                        break;
                    }
                    case 67: {
                        type = BARCODE_TYPE.EAN13x;
                        break;
                    }
                    case 68: {
                        type = BARCODE_TYPE.EANS;
                        break;
                    }
                    case 69: {
                        type = BARCODE_TYPE.CODE39x;
                        break;
                    }
                    case 70: {
                        type = BARCODE_TYPE.ITFx;
                        break;
                    }
                    case 71: {
                        type = BARCODE_TYPE.CODABARx;
                        break;
                    }
                    case 72: {
                        type = BARCODE_TYPE.CODE93;
                        break;
                    }
                    case 73: {
                        type = BARCODE_TYPE.CODE128;
                        break;
                    }
                    default: {
                        type = BARCODE_TYPE.EAN13;
                    }
                }
                if (fm.getFmState() != 1) break block23;
                try {
                    InternalDocument document = InternalDocument.getInstance();
                    document.addItem((MessageItemInterfaceParagon)ItemBarcode.getInstance((String)this.barcodeData, (BARCODE_TYPE)type, (BARCODE_TEXT_POSITION)fm.getTextPos(), (BARCODE_FONT_SIZE)fm.getTextFont(), (int)fm.getBarcodeH(), (int)fm.getBarcodeW()));
                    ppekk.process((AbstractCommand)document);
                    return status;
                }
                catch (EKasaException e) {
                    fm.setLastPPEKKError(e.getErrorCode());
                    return -3;
                }
            }
            catch (FmStoreToDbException e) {
                logger.fatal("Database error", (Throwable)e);
                return -2;
            }
        }
        fm.getParagon().addItem(new ItemModel.Builder().setDescription(this.barcodeData).setNonSpecificParams(new Object[]{type, fm.getTextPos(), fm.getTextFont(), fm.getBarcodeH(), fm.getBarcodeW()}).setItemType(ItemModel.ItemType.printBC).build());
        fm.getParagon().appendBinaryData(this.binary);
        fm.saveDbParagon();
        return status;
    }

    @Override
    protected byte parseParams() {
        block10: {
            block9: {
                FmFiscalMemory fm = this.eKasa.getFm();
                switch (fm.getFmState()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 10: 
                    case 20: 
                    case 32: 
                    case 34: {
                        break;
                    }
                    default: {
                        return 52;
                    }
                }
                if (this.params.length != 2) {
                    return 32;
                }
                try {
                    this.barcodeType = Integer.parseInt(this.params[0]);
                    if (this.barcodeType >= 0 && this.barcodeType <= 6 || this.barcodeType >= 65 && this.barcodeType <= 73) break block9;
                    return 96;
                }
                catch (NumberFormatException e) {
                    return 96;
                }
            }
            this.barcodeData = this.params[1];
            if (this.barcodeData.length() <= 40) break block10;
            return 33;
        }
        if (this.barcodeData.matches(".*[\\x00-\\x19].*")) {
            return 96;
        }
        return 0;
    }
}

