/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.nio.charset.Charset;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.chdu.DisplayData;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.Display;
import sk.singularisdev.ekasask.enumeration.DISPLAY_NUMBER;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class PrintDisplay
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)PrintDisplay.class.getName());
    private int displayType;
    private String text;

    public PrintDisplay(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block6: {
            byte status;
            block7: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block6;
                    status = this.parseParams();
                    if (status != 0) break block7;
                    try {
                        Display display = Display.getInstance((DISPLAY_NUMBER)(this.displayType == 0 ? DISPLAY_NUMBER.INTERNAL : DISPLAY_NUMBER.EXTERNAL));
                        DisplayData data = new DisplayData();
                        data.setData(Charset.forName("CP852").encode(this.text).array());
                        display.addDisplayData(data);
                        ppekk.process((AbstractCommand)display);
                    }
                    catch (EKasaException e) {
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        block8: {
            FmFiscalMemory fm = this.eKasa.getFm();
            switch (fm.getFmState()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 10: 
                case 20: 
                case 32: 
                case 33: 
                case 34: {
                    break;
                }
                default: {
                    return 52;
                }
            }
            if (this.params.length != 3) {
                return 32;
            }
            try {
                this.displayType = Integer.parseInt(this.params[0]);
                if (this.displayType >= 0 && this.displayType <= 9) break block8;
                return 96;
            }
            catch (NumberFormatException e) {
                return 96;
            }
        }
        this.text = this.params[2];
        if (this.text.length() > 40) {
            return 96;
        }
        return 0;
    }
}

