/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.InternalDocument;
import sk.singularisdev.ekasask.command.ItemPrintBinary;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.GetJournalStructU;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.enums.ParagonType;
import sk.singularisdev.ekasask.fm.util.Hex;

public class PrintJournalStructD
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)GetJournalStructU.class.getName());
    private ParagonType type;
    private String dateFrom;
    private String dateTo;

    public PrintJournalStructD(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (!fm.isDbOk()) return -2;
            byte status = this.parseParams();
            try {
                byte[] print = fm.getJournal(this.type, this.dateFrom, this.dateTo, null, null);
                if (print == null) return 4;
                if (print.length == 0) {
                    return 4;
                }
                InternalDocument document = InternalDocument.getInstance();
                document.setAutoCutter(true);
                document.addItem((MessageItemInterfaceParagon)ItemPrintBinary.getInstance((byte[])print));
                ppekk.process((AbstractCommand)document);
                return status;
            }
            catch (EKasaException e) {
                fm.setLastPPEKKError(e.getErrorCode());
                return -3;
            }
            catch (NumberFormatException e) {
                return 96;
            }
        }
        catch (FmStoreToDbException e) {
            if (e.getMessage().equals("java.sql.SQLException: No data")) {
                return 4;
            }
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block7: {
            FmFiscalMemory fm = this.eKasa.getFm();
            switch (fm.getFmState()) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    return 52;
                }
            }
            if (this.params.length != 3) {
                return 32;
            }
            try {
                this.type = ParagonType.fromName(this.params[0].charAt(0));
                if (this.type != null) break block7;
                return 96;
            }
            catch (ParseException e) {
                return 96;
            }
        }
        this.dateFrom = String.valueOf(Formatter.get().generateStringDate("yyyy-MM-dd", new SimpleDateFormat("ddMMyyyy").parse(this.params[1]))) + " 00:00:01";
        this.dateTo = String.valueOf(Formatter.get().generateStringDate("yyyy-MM-dd", new SimpleDateFormat("ddMMyyyy").parse(this.params[2]))) + " 23:59:59";
        return 0;
    }
}

