/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.setup.Setup;
import sk.singularisdev.ekasask.command.setup.SetupItemChduConnectionString;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.enums.SFSError;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.sfs.EKasaResponseException;

public class SetPCHDU
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetPCHDU.class.getName());
    private int interfaceType;
    private String interfaceDescription;

    public SetPCHDU(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block13: {
            byte status;
            block14: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block13;
                    status = this.parseParams();
                    if (status != 0) break block14;
                    try {
                        Setup setup = Setup.getInstance();
                        SetupItemChduConnectionString setupItem = SetupItemChduConnectionString.getInstance();
                        switch (this.interfaceType) {
                            case 0: {
                                setupItem.setConnectionString("RS232:" + this.interfaceDescription);
                                break;
                            }
                            case 1: {
                                setupItem.setConnectionString("TCP:" + this.interfaceDescription);
                                break;
                            }
                            case 2: {
                                setupItem.setConnectionString("BT:" + this.interfaceDescription);
                                break;
                            }
                            case 3: {
                                setupItem.setConnectionString("SUNMI_I2C:" + this.interfaceDescription);
                            }
                        }
                        setup.addItem((SetupItemInterface)setupItem);
                        ppekk.process((AbstractCommand)setup);
                    }
                    catch (EKasaResponseException e) {
                        fm.setLastSFSError(e.getResponseCode());
                        fm.setLastPPEKKError(e.getErrorCode());
                        return SFSError.fromSFSCode(e.getResponseCode()).getInternalFmInternalCode();
                    }
                    catch (EKasaException e) {
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        block5: {
            if (this.params.length != 2) {
                return 32;
            }
            try {
                this.interfaceType = Integer.parseInt(this.params[0]);
                if (this.interfaceType >= 0 && this.interfaceType <= 1) break block5;
                return 96;
            }
            catch (NumberFormatException e) {
                return 96;
            }
        }
        this.interfaceDescription = this.params[1];
        if (this.interfaceDescription.length() > 30) {
            return 96;
        }
        return 0;
    }
}

