/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetPassword
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetPassword.class.getName());
    public String oldPassword;
    public String newPassword;

    public SetPassword(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    fm.setPassword(this.newPassword);
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block7: {
            FmFiscalMemory fm;
            block6: {
                fm = this.eKasa.getFm();
                if (this.params.length != 2) {
                    return 32;
                }
                try {
                    this.oldPassword = Formatter.get().getMD5Format(this.params[0]);
                    if (this.params[0].length() >= 6 && this.params[0].length() <= 8) break block6;
                    return 96;
                }
                catch (NumberFormatException e) {
                    return 96;
                }
            }
            if (this.oldPassword.equals(fm.getPassword())) break block7;
            return 49;
        }
        this.newPassword = this.params[1];
        if (this.params[1].length() < 6 || this.params[1].length() > 8) {
            return 96;
        }
        return 0;
    }
}

