/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;

public class SetPreline
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetPreline.class.getName());
    private String description;

    public SetPreline(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    fm.setPreline(this.description);
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block6: {
            FmFiscalMemory fm = this.eKasa.getFm();
            PPEKK ppekk = this.eKasa.getPPEKK();
            if (fm.getFmState() != 2) {
                return 52;
            }
            if (this.params.length != 1) {
                return 32;
            }
            try {
                this.description = this.params[0];
                if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)true) <= fm.getCharCount()) break block6;
                return 33;
            }
            catch (NumberFormatException e) {
                return 96;
            }
        }
        if (this.description.matches(".*[\\x00-\\x19].*")) {
            return 96;
        }
        return 0;
    }
}

