/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.setup.Setup;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.command.setup.SetupItemPrinterBaudrate;
import sk.singularisdev.ekasask.command.setup.SetupItemPrinterType;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.enums.Baudrate;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.driver.BL112N;
import sk.singularisdev.ekasask.printer.driver.Gimex;
import sk.singularisdev.ekasask.printer.driver.MarkEETa;
import sk.singularisdev.ekasask.printer.driver.Modulino;
import sk.singularisdev.ekasask.printer.driver.Modulino32;
import sk.singularisdev.ekasask.printer.driver.PCPOS1_57;
import sk.singularisdev.ekasask.printer.driver.PegasinoFTN;
import sk.singularisdev.ekasask.printer.driver.RONGTA80;
import sk.singularisdev.ekasask.printer.driver.SPPR310;
import sk.singularisdev.ekasask.printer.driver.SPPR410;
import sk.singularisdev.ekasask.printer.driver.SRP350IIN;
import sk.singularisdev.ekasask.printer.driver.SRP350N;
import sk.singularisdev.ekasask.printer.driver.SRPN350;
import sk.singularisdev.ekasask.printer.driver.SRPN350II;
import sk.singularisdev.ekasask.printer.driver.Sam4S;
import sk.singularisdev.ekasask.printer.driver.SunmiN;
import sk.singularisdev.ekasask.printer.driver.TMH6000;
import sk.singularisdev.ekasask.printer.driver.TMT88III;
import sk.singularisdev.ekasask.printer.driver.TMT88V;

public class SetPrinterType
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetPrinterType.class.getName());
    private String password;
    private int printerType;
    private int printerBaud;

    public SetPrinterType(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block31: {
            byte status;
            block32: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block31;
                    status = this.parseParams();
                    if (status != 0) break block32;
                    try {
                        Setup setup = Setup.getInstance();
                        SetupItemPrinterType printer = SetupItemPrinterType.getInstance();
                        SetupItemPrinterBaudrate baudrate = SetupItemPrinterBaudrate.getInstance();
                        switch (this.printerType) {
                            case 0: {
                                printer.setPrinterType(SRP350N.class.getName());
                                fm.setCharCount(SRP350N.getInstance().getCharPerRow());
                                break;
                            }
                            case 1: {
                                printer.setPrinterType(SRPN350.class.getName());
                                fm.setCharCount(SRPN350.getInstance().getCharPerRow());
                                break;
                            }
                            case 9: {
                                printer.setPrinterType(TMT88V.class.getName());
                                fm.setCharCount(TMT88V.getInstance().getCharPerRow());
                                break;
                            }
                            case 25: {
                                printer.setPrinterType(PCPOS1_57.class.getName());
                                fm.setCharCount(PCPOS1_57.getInstance().getCharPerRow());
                                break;
                            }
                            case 33: {
                                printer.setPrinterType(SRP350IIN.class.getName());
                                fm.setCharCount(SRP350IIN.getInstance().getCharPerRow());
                                break;
                            }
                            case 34: {
                                printer.setPrinterType(RONGTA80.class.getName());
                                fm.setCharCount(RONGTA80.getInstance().getCharPerRow());
                                break;
                            }
                            case 35: {
                                printer.setPrinterType(MarkEETa.class.getName());
                                fm.setCharCount(MarkEETa.getInstance().getCharPerRow());
                                break;
                            }
                            case 36: {
                                printer.setPrinterType(Modulino.class.getName());
                                fm.setCharCount(Modulino.getInstance().getCharPerRow());
                                break;
                            }
                            case 37: {
                                printer.setPrinterType(SunmiN.class.getName());
                                fm.setCharCount(SunmiN.getInstance().getCharPerRow());
                                break;
                            }
                            case 38: {
                                printer.setPrinterType(Gimex.class.getName());
                                fm.setCharCount(Gimex.getInstance().getCharPerRow());
                                break;
                            }
                            case 39: {
                                printer.setPrinterType(Modulino32.class.getName());
                                fm.setCharCount(Modulino32.getInstance().getCharPerRow());
                                break;
                            }
                            case 40: {
                                printer.setPrinterType(SRPN350II.class.getName());
                                fm.setCharCount(SRPN350II.getInstance().getCharPerRow());
                                break;
                            }
                            case 41: {
                                printer.setPrinterType(SPPR310.class.getName());
                                fm.setCharCount(SPPR310.getInstance().getCharPerRow());
                                break;
                            }
                            case 42: {
                                printer.setPrinterType(Sam4S.class.getName());
                                fm.setCharCount(Sam4S.getInstance().getCharPerRow());
                                break;
                            }
                            case 43: {
                                printer.setPrinterType(SPPR410.class.getName());
                                fm.setCharCount(SPPR410.getInstance().getCharPerRow());
                                break;
                            }
                            case 44: {
                                printer.setPrinterType(TMH6000.class.getName());
                                fm.setCharCount(TMH6000.getInstance().getCharPerRow());
                                break;
                            }
                            case 45: {
                                printer.setPrinterType(TMT88III.class.getName());
                                fm.setCharCount(TMT88III.getInstance().getCharPerRow());
                                break;
                            }
                            case 101: {
                                printer.setPrinterType(PegasinoFTN.class.getName());
                                fm.setCharCount(PegasinoFTN.getInstance().getCharPerRow());
                                break;
                            }
                            case 102: {
                                printer.setPrinterType(BL112N.class.getName());
                                fm.setCharCount(BL112N.getInstance().getCharPerRow());
                                break;
                            }
                            default: {
                                printer.setPrinterType(SRP350N.class.getName());
                                fm.setCharCount(SRP350N.getInstance().getCharPerRow());
                            }
                        }
                        if (this.printerBaud > 4) {
                            baudrate.setBaudrate(this.printerBaud);
                        } else {
                            baudrate.setBaudrate(Baudrate.fromFmId(this.printerBaud).getBaudrate());
                        }
                        setup.addItem((SetupItemInterface)printer);
                        setup.addItem((SetupItemInterface)baudrate);
                        ppekk.process((AbstractCommand)setup);
                        fm.setPrinterType(this.printerType);
                        if (this.printerBaud > 4) {
                            fm.setPrinterBaud(this.printerBaud);
                        } else {
                            fm.setPrinterBaud(Baudrate.fromFmId(this.printerBaud).getBaudrate());
                        }
                    }
                    catch (EKasaException e) {
                        System.out.println("PPEKK ERR: " + e.getErrorCode());
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        block14: {
            FmFiscalMemory fm;
            block13: {
                fm = this.eKasa.getFm();
                switch (fm.getFmState()) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    default: {
                        return 52;
                    }
                }
                if (this.params.length != 3) {
                    return 32;
                }
                try {
                    this.password = Formatter.get().getMD5Format(this.params[0]);
                    if (this.params[0].length() >= 6 && this.params[0].length() <= 8) break block13;
                    return 96;
                }
                catch (NumberFormatException e) {
                    return 96;
                }
            }
            if (this.password.equals(fm.getPassword())) break block14;
            return 49;
        }
        this.printerType = Integer.parseInt(this.params[1]);
        switch (this.printerType) {
            case 0: 
            case 1: 
            case 9: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 101: 
            case 102: {
                break;
            }
            default: {
                return 96;
            }
        }
        this.printerBaud = Integer.parseInt(this.params[2]);
        if (!(this.printerBaud >= 0 && this.printerBaud <= 8 || this.printerBaud >= 40 && this.printerBaud <= 1200)) {
            return 96;
        }
        return 0;
    }
}

