/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.setup.Setup;
import sk.singularisdev.ekasask.command.setup.SetupItemIdentityData;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetSubjectIDData
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetSubjectIDData.class.getName());
    public String xmlPath;

    public SetSubjectIDData(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (!fm.isDbOk()) return -2;
            byte status = this.parseParams();
            if (status != 0) return status;
            try {
                Setup setup = Setup.getInstance();
                SetupItemIdentityData setupItemIdentity = SetupItemIdentityData.getInstance();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.xmlPath), "UTF8"));
                String line = null;
                StringBuilder stringBuilder = new StringBuilder();
                String ls = System.getProperty("line.separator");
                try {
                    while ((line = reader.readLine()) != null) {
                        stringBuilder.append(line);
                        stringBuilder.append(ls);
                    }
                }
                finally {
                    reader.close();
                }
                setupItemIdentity.setIdentityData(stringBuilder.toString());
                setup.addItem((SetupItemInterface)setupItemIdentity);
                ppekk.process((AbstractCommand)setup);
                return status;
            }
            catch (EKasaException e) {
                fm.setLastPPEKKError(e.getErrorCode());
                return -3;
            }
            catch (UnsupportedEncodingException e) {
                return -47;
            }
            catch (FileNotFoundException e) {
                return -48;
            }
            catch (IOException e) {
                return -47;
            }
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 1) {
            return 32;
        }
        this.xmlPath = this.params[0];
        if (this.xmlPath.length() > 255) {
            return 32;
        }
        return 0;
    }
}

