/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.math.BigDecimal;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;

public class SubTotal
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SubTotal.class.getName());
    private int row;
    private String description;
    private int vatFlag;

    public SubTotal(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    BigDecimal actualSubtotal = BigDecimal.ZERO;
                    if (fm.isVatPayer()) {
                        switch (this.vatFlag) {
                            case 0: {
                                actualSubtotal = fm.getReceiptTotalWithVat();
                                break;
                            }
                            case 1: {
                                actualSubtotal = fm.getReceiptTotalNoVat();
                            }
                        }
                    } else {
                        actualSubtotal = fm.getReceiptTotalWithVat();
                    }
                    fm.getParagon().addItem(new ItemModel.Builder().setRow(this.row).setDescription(this.description).setVatFlag(this.vatFlag).setTotalPrice(actualSubtotal.toString()).setItemType(ItemModel.ItemType.subTotal).build());
                    fm.getParagon().appendBinaryData(this.binary);
                    fm.saveDbParagon();
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block12: {
            block11: {
                PPEKK ppekk;
                block10: {
                    FmFiscalMemory fm;
                    block9: {
                        fm = this.eKasa.getFm();
                        ppekk = this.eKasa.getPPEKK();
                        if (fm.getFmState() != 2) {
                            return 52;
                        }
                        if (this.params.length != 3) {
                            return 32;
                        }
                        try {
                            this.row = Integer.parseInt(this.params[0]);
                            if (this.row >= 0 && this.row <= 9) break block9;
                            return 96;
                        }
                        catch (NumberFormatException e) {
                            return 96;
                        }
                    }
                    if (!fm.isSafeMode() || fm.getActualRow() == this.row - 1) break block10;
                    return 67;
                }
                this.description = this.params[1];
                if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)false) <= 20) break block11;
                return 33;
            }
            if (!this.description.matches(".*[\\x00-\\x19].*")) break block12;
            return 96;
        }
        this.vatFlag = Integer.parseInt(this.params[2]);
        if (this.vatFlag < 0 || this.vatFlag > 1) {
            return 96;
        }
        return 0;
    }
}

