/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.math.BigDecimal;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.Checkers;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;

public class VymenaPoukazu
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)VymenaPoukazu.class.getName());
    private String description;
    private String voucherID;
    private BigDecimal quantity;
    private BigDecimal totalPrice;
    private char vat;

    public VymenaPoukazu(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block9: {
            byte status;
            block10: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block9;
                    status = this.parseParams();
                    if (status != 0) break block10;
                    fm.beginTransaction();
                    if (fm.getFmState() != 43) {
                        fm.setFmState(43);
                    }
                    if (fm.getReceiptTotalWithVat().compareTo(BigDecimal.ZERO) == 1) {
                        BigDecimal newLocalTotal = fm.getVat(this.vat).getLocalTotal().add(this.totalPrice.negate());
                        if (newLocalTotal.compareTo(BigDecimal.ZERO) == -1) {
                            fm.appendReceiptTotal(fm.getVat(this.vat).getLocalTotal());
                            fm.getVat(this.vat).setLocalTotal(BigDecimal.ZERO);
                        } else {
                            fm.appendReceiptTotal(this.totalPrice.negate());
                            fm.getVat(this.vat).setLocalTotal(newLocalTotal);
                        }
                        if (fm.getReceiptTotalWithVat().compareTo(BigDecimal.ZERO) == 0) {
                            fm.setFmState(4);
                        }
                        fm.getParagon().addItem(new ItemModel.Builder().setDescription(this.description).setTotalPrice(this.totalPrice.toString()).setVat(this.vat).setQuantity(this.quantity.toString()).setItemType(ItemModel.ItemType.voucher).setNonSpecificParams(new Object[]{this.voucherID}).build());
                        fm.getParagon().appendBinaryData(this.binary);
                        fm.saveDbParagon();
                        fm.setTransactionSuccesfull();
                        fm.endTransaction();
                        break block10;
                    }
                    return 52;
                }
                catch (FmStoreToDbException e) {
                    fm.endTransaction();
                    logger.fatal("Database error", (Throwable)e);
                    Function.initFMDB(fm);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        block26: {
            block25: {
                block24: {
                    FmFiscalMemory fm;
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            PPEKK ppekk;
                                            block17: {
                                                fm = this.eKasa.getFm();
                                                ppekk = this.eKasa.getPPEKK();
                                                switch (fm.getFmState()) {
                                                    case 2: 
                                                    case 43: {
                                                        break;
                                                    }
                                                    default: {
                                                        return 52;
                                                    }
                                                }
                                                if (this.params.length != 5) {
                                                    return 32;
                                                }
                                                this.description = this.params[0];
                                                if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)false) <= fm.getCharCount()) break block17;
                                                return 33;
                                            }
                                            if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)false) != 0) break block18;
                                            return 33;
                                        }
                                        if (!this.description.matches(".*[\\x00-\\x19].*")) break block19;
                                        return 96;
                                    }
                                    this.description.replaceAll("\\*", " ");
                                    this.quantity = new BigDecimal(this.params[1]);
                                    if (Checkers.get().checkValueFormat(this.params[1], 6, 2)) break block20;
                                    return 33;
                                }
                                if (this.params[2].length() <= 1) break block21;
                                return 33;
                            }
                            this.vat = this.params[2].charAt(0);
                            if (fm.validateVat(this.vat)) break block22;
                            return 96;
                        }
                        this.totalPrice = new BigDecimal(this.params[3]);
                        if (Checkers.get().checkValueFormat(this.params[3], 6, 2)) break block23;
                        return 33;
                    }
                    this.voucherID = this.params[4];
                    if (this.voucherID.length() <= fm.getCharCount()) break block24;
                    return 96;
                }
                if (this.voucherID.length() != 0) break block25;
                return 96;
            }
            if (!this.voucherID.matches(".*[\\x00-\\x19].*")) break block26;
            return 96;
        }
        try {
            this.voucherID.replaceAll("\\*", " ");
        }
        catch (NumberFormatException e) {
            return 96;
        }
        catch (Exception e) {
            return 96;
        }
        return 0;
    }
}

