/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.common;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import sk.singularisdev.ekasask.fm.enums.Align;
import sk.singularisdev.ekasask.fm.enums.VariableCodes;
import sk.singularisdev.ekasask.fm.util.Base64;

public class Formatter {
    private static final Formatter formater = new Formatter();

    public static Formatter get() {
        return formater;
    }

    private Formatter() {
    }

    public String generateVariableFormat(VariableCodes vCode, Object[] data) {
        String builder = "";
        builder = String.valueOf(builder) + vCode.getValue();
        int paramsCount = vCode.getParamCount();
        int i = 0;
        while (i < paramsCount) {
            builder = String.valueOf(builder) + ";%s";
            ++i;
        }
        return String.format(builder.toString(), data);
    }

    public String generateStringDate(String format, Date date) {
        return new SimpleDateFormat(format).format(date);
    }

    public String repeat(char repeatableChar, int count) {
        char[] chars = new char[count];
        Arrays.fill(chars, repeatableChar);
        return new String(chars);
    }

    public String align(String source, int maxChars, Align align) {
        switch (align) {
            case center: {
                return String.format("%" + (maxChars / 2 + source.length() / 2) + "s", source);
            }
            case right: {
                return String.format("%" + maxChars + "s", source);
            }
        }
        return source;
    }

    public String getMD5Format(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(input.getBytes());
            return Base64.toString(array);
        }
        catch (NoSuchAlgorithmException e) {
            return input;
        }
    }

    public String StringArrayToString(String[] array) {
        StringBuilder bl = new StringBuilder();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            bl.append(row).append(";");
            ++n2;
        }
        return bl.toString();
    }

    public String[] Split(String input, int splitSize) {
        char[] data = input.toCharArray();
        int len = data.length;
        String[] result = new String[(len + splitSize - 1) / splitSize];
        int linha = 0;
        int i = 0;
        while (i < len) {
            result[linha] = new String(data, i, Math.min(splitSize, len - i));
            ++linha;
            i += splitSize;
        }
        return result;
    }

    public boolean isOSTimeZoneCorrect() {
        return TimeUnit.MILLISECONDS.toHours(TimeZone.getDefault().getRawOffset()) == 1L;
    }

    public String istripAccents(String input) {
        String noAccents = Normalizer.normalize(input, Normalizer.Form.NFD);
        return noAccents.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
    }

    private int toDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }

    public byte[] decodeHexString(String hexString) {
        if (hexString.length() % 2 == 1) {
            throw new IllegalArgumentException("Invalid hexadecimal String supplied.");
        }
        byte[] bytes = new byte[hexString.length() / 2];
        int i = 0;
        while (i < hexString.length()) {
            String parcial = hexString.substring(i, i + 2);
            int firstDigit = this.toDigit(parcial.charAt(0));
            int secondDigit = this.toDigit(parcial.charAt(1));
            bytes[i / 2] = (byte)((firstDigit << 4) + secondDigit);
            i += 2;
        }
        return bytes;
    }
}

