/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.communication;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.fm.Constant;
import sk.singularisdev.ekasask.fm.Daemon;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.communication.AppDriverTcpIpClientBuffer;
import sk.singularisdev.ekasask.fm.interfaces.BlockOutInterface;
import sk.singularisdev.ekasask.fm.util.Hex;

public class AppDriverTcpIpClient
extends AppCommunicationDriver
implements Runnable {
    private static final int TIMEOUT = 2;
    public static final byte NUL = 0;
    public static final byte ETX = 3;
    public static final byte EOT = 4;
    public static final byte ACK = 6;
    public static final byte XON = 17;
    public static final byte XOFF = 19;
    public static final byte NAK = 21;
    public static final byte ETB = 23;
    public static final byte FS = 28;
    public static final byte BLOCK_BEGIN = 58;
    private static final Logger logger = LoggerManager.getLogger((String)AppDriverTcpIpClient.class.getName());
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private AppDriverTcpIpClientBuffer buffer;

    public AppDriverTcpIpClient(Socket socket) throws Exception {
        this.socket = socket;
        socket.setSoTimeout(2);
        this.inputStream = new BufferedInputStream(socket.getInputStream());
        this.outputStream = new BufferedOutputStream(socket.getOutputStream());
        this.buffer = new AppDriverTcpIpClientBuffer(300, this.inputStream);
    }

    public Socket getSocket() {
        return this.socket;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.running = true;
        this.stopSignal = false;
        errorCount = 3;
        try lbl-1000:
        // 2 sources

        {
            while (true) {
                block17: {
                    block18: {
                        block19: {
                            if (!this.running) {
                                return;
                            }
                            if (this.state == AppCommunicationDriver.STATE.WAITING) {
                                if (this.buffer.isNextByte((byte)17)) {
                                    this.buffer.getByte();
                                    this.outputStream.write(new byte[]{19});
                                    this.outputStream.flush();
                                    continue;
                                }
                                try {
                                    Thread.sleep(2L);
                                }
                                catch (Exception var2_2) {}
                                continue;
                            }
                            d = this.buffer.getByte();
                            if (d < 0) continue;
                            b = (byte)d;
                            if (b == 17) {
                                this.outputStream.write(new byte[]{17});
                                this.outputStream.flush();
                                continue;
                            }
                            if (b != 28) break block17;
                            data = this.buffer.getPacket();
                            AppDriverTcpIpClient.logger.debug("[TCPIP CLIENT SOCKET] DATA IN: " + Hex.toHexString(data));
                            l = data.length;
                            if (l < 4) {
                                this.outputStream.write(new byte[]{4});
                                this.outputStream.flush();
                                continue;
                            }
                            if (data[l - 2] != 4) break block18;
                            bcc = AppDriverTcpIpClient.calcBcc(data, l - 1, (byte)28);
                            if (bcc != data[l - 1]) break block19;
                            params = new String[20];
                            deviceNumber = (long)data[0] & 255L;
                            cmd = data[1];
                            index = 0;
                            pos = 2;
                            i = 2;
                            if (true) ** GOTO lbl80
                        }
                        if (--errorCount == 0) {
                            this.outputStream.write(new byte[]{4});
                            AppDriverTcpIpClient.logger.debug("[\tDATA] UKONCENIE " + Hex.toHexString(new byte[]{4}));
                            this.outputStream.flush();
                            errorCount = 3;
                            continue;
                        }
                        this.sendError((byte)65);
                        continue;
                    }
                    this.outputStream.write(new byte[]{4});
                    AppDriverTcpIpClient.logger.debug("[\tDATA] UKONCENIE " + Hex.toHexString(new byte[]{4}));
                    this.outputStream.flush();
                    continue;
                }
                this.outputStream.write(new byte[]{4});
                AppDriverTcpIpClient.logger.debug("[\tDATA] UKONCENIE " + Hex.toHexString(new byte[]{4}));
                this.outputStream.flush();
                continue;
                break;
            }
        }
        catch (IOException e) {
            if (e.getMessage().contains("reset by peer")) {
                AppDriverTcpIpClient.logger.info("[\tSOCKET] Socket closed by server client");
                return;
            }
            e.printStackTrace();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return;
        do {
            if (data[i] == 0) {
                if (index < 20) {
                    params[index] = new String(data, pos, i - pos, Constant.CHARSET);
                }
                pos = i + 1;
                ++index;
            }
            ++i;
lbl80:
            // 2 sources

        } while (i < l - 2);
        if (pos < l - 3) {
            params[index] = new String(data, pos, l - 3, Constant.CHARSET);
            ++index;
        }
        p = new String[index];
        System.arraycopy(params, 0, p, 0, p.length);
        t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: {
                    try {
                        try {
                            EKasa eKasa = Daemon.getInstance().getEKasa(deviceNumber);
                            if (eKasa == null) {
                                AppDriverTcpIpClient.this.sendError((byte)-1);
                                break block9;
                            }
                            EKasa eKasa2 = eKasa;
                            synchronized (eKasa2) {
                                FmCommand command = eKasa.getCommand(AppDriverTcpIpClient.this, cmd, data, p);
                                command.process();
                            }
                        }
                        catch (IOException e) {
                            logger.fatal("", (Throwable)e);
                            AppDriverTcpIpClient.this.setState(AppCommunicationDriver.STATE.READY_TO_READ);
                        }
                    }
                    finally {
                        AppDriverTcpIpClient.this.setState(AppCommunicationDriver.STATE.READY_TO_READ);
                    }
                }
            }
        });
        this.setState(AppCommunicationDriver.STATE.WAITING);
        t.start();
        ** while (true)
    }

    @Override
    public void sendError(byte error) throws IOException {
        this.outputStream.write(new byte[]{21, error});
        logger.debug("[\tDATA] UKONCENIE " + Hex.toHexString(new byte[]{21, error}));
        this.outputStream.flush();
    }

    @Override
    public void sendOk() throws IOException {
        this.outputStream.write(new byte[]{6});
        logger.debug("[\tDATA] UKONCENIE " + Hex.toHexString(new byte[]{6}));
        this.outputStream.flush();
    }

    @Override
    public boolean readBlockData(BlockOutInterface blockOut) throws IOException {
        boolean rVal;
        block9: {
            int errorCount = 3;
            rVal = false;
            while (this.buffer.isNextByte((byte)58, 3000L)) {
                this.buffer.getByte(3000L);
                int length = this.buffer.getByte(3000L) + 1;
                if (length <= 0) continue;
                byte[] blockData = new byte[length];
                int i = 0;
                while (i < length) {
                    blockData[i] = (byte)this.buffer.getByte(3000L);
                    ++i;
                }
                byte endByte = (byte)this.buffer.getByte(3000L);
                byte crc = (byte)this.buffer.getByte(3000L);
                byte[] b1 = new byte[length + 3];
                b1[0] = 58;
                b1[1] = (byte)(length - 1);
                System.arraycopy(blockData, 0, b1, 2, length);
                b1[length + 2] = endByte;
                byte bcc = AppDriverTcpIpClient.calcBcc(b1, length + 3);
                if (bcc == crc) {
                    byte status;
                    if (endByte == 23) {
                        status = blockOut.block(blockData, false);
                        if (status == 0) {
                            errorCount = 3;
                            this.sendOk();
                            continue;
                        }
                        if (errorCount == 0) {
                            this.outputStream.write(new byte[]{4});
                            this.outputStream.flush();
                            errorCount = 3;
                            break block9;
                        }
                        this.sendError(status);
                        continue;
                    }
                    if (endByte != 3) continue;
                    status = blockOut.block(blockData, true);
                    if (status == 0) {
                        errorCount = 3;
                        this.sendOk();
                        rVal = true;
                        break block9;
                    }
                    if (--errorCount == 0) {
                        this.outputStream.write(new byte[]{4});
                        this.outputStream.flush();
                        errorCount = 3;
                        break block9;
                    }
                    this.sendError(status);
                    continue;
                }
                if (--errorCount == 0) {
                    this.outputStream.write(new byte[]{4});
                    this.outputStream.flush();
                    errorCount = 3;
                    break block9;
                }
                this.sendError((byte)65);
            }
            this.outputStream.write(new byte[]{4});
            this.outputStream.flush();
            errorCount = 3;
        }
        return rVal;
    }

    @Override
    public boolean sendData(byte[] data, boolean last) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int length = data.length;
        int pos = 0;
        while (pos < length) {
            baos.reset();
            baos.write(58);
            boolean etx = false;
            if (length - pos > 256) {
                baos.write(-1);
                baos.write(data, pos, 256);
                pos += 256;
                baos.write(23);
            } else {
                int l = length - pos;
                baos.write((byte)(l - 1));
                baos.write(data, pos, l);
                pos += length;
                if (last) {
                    etx = true;
                    baos.write(3);
                } else {
                    baos.write(23);
                }
            }
            byte[] b = baos.toByteArray();
            byte bcc = AppDriverTcpIpClient.calcBcc(b, b.length);
            int answer = 17;
            int counter = 3;
            while (counter > 0) {
                this.outputStream.write(b);
                this.outputStream.write(bcc);
                logger.debug("[\tDATA] DATA BLOCK SEND " + Hex.toHexString(b));
                logger.debug("[\tDATA] DATA BLOCK SEND " + Hex.toHexString(new byte[]{bcc}));
                this.outputStream.flush();
                while (true) {
                    if ((answer = this.buffer.getByte()) >= 0) {
                        if (answer != 17) break;
                        this.outputStream.write(19);
                        this.outputStream.flush();
                        continue;
                    }
                    try {
                        Thread.sleep(2L);
                    }
                    catch (Exception exception) {}
                }
                if (answer != 21) break;
                --counter;
            }
            if (answer == 6) continue;
            if (answer == 21) {
                this.outputStream.write(4);
                this.outputStream.flush();
                return false;
            }
            if (etx && answer == 3) {
                return true;
            }
            if (answer == 4) {
                this.outputStream.write(4);
                this.outputStream.flush();
                return false;
            }
            this.outputStream.write(4);
            this.outputStream.flush();
            return false;
        }
        this.outputStream.write(4);
        this.outputStream.flush();
        return false;
    }
}

