/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.communication;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.fm.communication.AppDriverTcpIpClient;
import sk.singularisdev.ekasask.fm.util.Hex;

public class AppDriverTcpIpClientBuffer {
    private int pos = 0;
    private int length = 0;
    private byte[] buffer;
    private int bufferSize;
    private InputStream inputStream;
    private static final Logger logger = LoggerManager.getLogger((String)AppDriverTcpIpClient.class.getName());

    public AppDriverTcpIpClientBuffer(int bufferSize, InputStream inputStream) {
        this.bufferSize = bufferSize;
        this.inputStream = inputStream;
        this.buffer = new byte[bufferSize];
    }

    public synchronized void read() throws IOException {
        while (this.length < this.bufferSize) {
            int p = this.pos + this.length;
            int space = this.bufferSize - p;
            byte[] data = new byte[space];
            try {
                int available = this.inputStream.read(data);
                logger.debug("[\tDATA] INPUT BUFFER: " + available + " | " + Hex.toHexString(data));
                if (available == -1) {
                    throw new IOException("reset by peer");
                }
                if (space < available || space == 0 && available == 0) {
                    logger.debug("[\tDATA] STAV AVAILABLE | SPACE: " + available + " | " + space);
                    byte[] newBuffer = new byte[this.bufferSize];
                    System.arraycopy(this.buffer, this.pos, newBuffer, 0, this.length);
                    this.buffer = newBuffer;
                    this.pos = 0;
                    p = this.pos + this.length;
                    space = this.bufferSize - p;
                }
                System.arraycopy(data, 0, this.buffer, p, available);
                this.length += available;
            }
            catch (SocketTimeoutException e) {
                return;
            }
        }
    }

    public synchronized int length() {
        return this.length;
    }

    public synchronized int getByte() throws IOException {
        return this.getByte(0L);
    }

    public synchronized int getByte(long timeout) throws IOException {
        block2: {
            if (this.length == 0) {
                long time = System.currentTimeMillis();
                do {
                    this.read();
                    if (this.length != 0) break block2;
                } while (System.currentTimeMillis() - time < timeout);
                return -1;
            }
        }
        ++this.pos;
        --this.length;
        logger.debug("[\tDATA] IDENT. BYTE: " + Hex.toHexString(new byte[]{(byte)(this.buffer[this.pos - 1] & 0xFF)}));
        return this.buffer[this.pos - 1] & 0xFF;
    }

    public synchronized boolean isNextByte(byte nextByte) throws IOException {
        return this.isNextByte(nextByte, 0L);
    }

    public synchronized boolean isNextByte(byte nextByte, long timeout) throws IOException {
        block2: {
            if (this.length == 0) {
                long time = System.currentTimeMillis();
                do {
                    this.read();
                    if (this.length != 0) break block2;
                } while (System.currentTimeMillis() - time <= timeout);
                return false;
            }
        }
        return this.buffer[this.pos] == nextByte;
    }

    public synchronized byte[] getPacket() throws IOException {
        long time = System.currentTimeMillis();
        while (System.currentTimeMillis() - time < 3000L) {
            int i = 0;
            while (i < this.length) {
                if (this.buffer[this.pos + i] == 4 && i + 1 < this.length) {
                    byte[] b = new byte[i + 2];
                    System.arraycopy(this.buffer, this.pos, b, 0, b.length);
                    this.pos = this.pos + i + 2;
                    this.length -= i + 2;
                    logger.debug("[\tDATA] BUFFER " + Hex.toHexString(b));
                    return b;
                }
                ++i;
            }
            this.read();
        }
        return new byte[0];
    }
}

