/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.communication;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.communication.AppDriverTcpIpClient;
import sk.singularisdev.ekasask.fm.communication.Driver;
import sk.singularisdev.ekasask.fm.interfaces.BlockOutInterface;

public class SuperserverDriverTcpIp
extends AppCommunicationDriver {
    private int port;
    private ServerSocket listenSocket;
    private Map<Socket, Driver> clients = new HashMap<Socket, Driver>();

    public SuperserverDriverTcpIp(int port) throws Exception {
        this.port = port;
        this.listenSocket = new ServerSocket(this.port);
        this.listenSocket.setSoTimeout(10000);
    }

    public void removeSocket(Socket socket) {
        this.clients.remove(socket);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.running = true;
        this.stopSignal = false;
        try {
            while (true) {
                if (!this.running) {
                    this.listenSocket.close();
                    this.stopSignal = true;
                    return;
                }
                try {
                    Socket socket = this.listenSocket.accept();
                    AppDriverTcpIpClient client = new AppDriverTcpIpClient(socket);
                    this.clients.put(socket, client);
                    client.startDriver();
                }
                catch (SocketTimeoutException socket) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.listenSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stopSignal = true;
        }
    }

    @Override
    public void sendError(byte error) throws IOException {
    }

    @Override
    public void sendOk() throws IOException {
    }

    @Override
    public boolean sendData(byte[] data, boolean last) throws IOException {
        return false;
    }

    @Override
    public boolean readBlockData(BlockOutInterface blockOut) throws IOException {
        return false;
    }
}

