/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.data;

import java.math.BigDecimal;
import java.sql.SQLException;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.db.enums.RowPrefix;
import sk.singularisdev.ekasask.fm.db.enums.Rows;
import sk.singularisdev.ekasask.fm.db.enums.Tables;
import sk.singularisdev.ekasask.fm.db.helpers.ContentValues;

public class DiscountTurnover {
    private FmFiscalMemory fm;
    private boolean global;
    private boolean percent;
    private BigDecimal discountItem;
    private BigDecimal discountSubtotal;
    private BigDecimal surchargeItem;
    private BigDecimal surchargeSubtotal;
    private int discountItemCounter;
    private int surchargeItemCounter;
    private int discountSubtotalCounter;
    private int surchargeSubtotalCounter;

    public DiscountTurnover(Builder builder) throws FmStoreToDbException {
        this.fm = builder.fm;
        this.global = builder.global;
        this.percent = builder.percent;
        this.discountItem = builder.discountItem;
        this.discountSubtotal = builder.discountSubtotal;
        this.surchargeItem = builder.surchargeItem;
        this.surchargeSubtotal = builder.surchargeSubtotal;
        this.discountItemCounter = builder.discountItemCounter;
        this.discountSubtotalCounter = builder.discountSubtotalCounter;
        this.surchargeItemCounter = builder.surchargeItemCounter;
        this.surchargeSubtotalCounter = builder.surchargeSubtotalCounter;
        this.saveToDb();
    }

    private void resetDiscountTurnover(DiscountTurnover builder) throws FmStoreToDbException {
        this.discountItem = builder.discountItem;
        this.discountSubtotal = builder.discountSubtotal;
        this.surchargeItem = builder.surchargeItem;
        this.surchargeSubtotal = builder.surchargeSubtotal;
        this.discountItemCounter = builder.discountItemCounter;
        this.discountSubtotalCounter = builder.discountSubtotalCounter;
        this.surchargeItemCounter = builder.surchargeItemCounter;
        this.surchargeSubtotalCounter = builder.surchargeSubtotalCounter;
        this.saveToDb();
    }

    public void tilt(DiscountTurnover discountTurnover) throws FmStoreToDbException {
        this.discountItem = this.discountItem.add(discountTurnover.discountItem);
        this.surchargeItem = this.surchargeItem.add(discountTurnover.surchargeItem);
        this.discountSubtotal = this.discountSubtotal.add(discountTurnover.discountSubtotal);
        this.surchargeSubtotal = this.surchargeSubtotal.add(discountTurnover.surchargeSubtotal);
        this.discountItemCounter += discountTurnover.discountItemCounter;
        this.surchargeItemCounter += discountTurnover.surchargeItemCounter;
        this.discountSubtotalCounter += discountTurnover.discountSubtotalCounter;
        this.surchargeSubtotalCounter += discountTurnover.surchargeSubtotalCounter;
        this.saveToDb();
    }

    public void reset() throws FmStoreToDbException {
        this.resetDiscountTurnover(new Builder(this.fm, this.global, this.percent).build());
    }

    private void saveToDb() throws FmStoreToDbException {
        if (this.fm != null) {
            try {
                ContentValues values = new ContentValues();
                RowPrefix prefixGlobal = this.global ? RowPrefix.global : RowPrefix.local;
                RowPrefix prefixPercent = this.percent ? RowPrefix.percent : RowPrefix.value;
                values.put(Rows.Total.fullPrefixRow(RowPrefix.discount, prefixPercent, prefixGlobal), this.discountItem.toString());
                values.put(Rows.Counter.fullPrefixRow(RowPrefix.discount, prefixPercent, prefixGlobal), this.discountItemCounter);
                values.put(Rows.Total.fullPrefixRow(RowPrefix.surcharge, prefixPercent, prefixGlobal), this.surchargeItem.toString());
                values.put(Rows.Counter.fullPrefixRow(RowPrefix.surcharge, prefixPercent, prefixGlobal), this.surchargeItemCounter);
                values.put(Rows.Total.fullPrefixRow(RowPrefix.subtotalDiscount, prefixPercent, prefixGlobal), this.discountSubtotal.toString());
                values.put(Rows.Counter.fullPrefixRow(RowPrefix.subtotalDiscount, prefixPercent, prefixGlobal), this.discountSubtotalCounter);
                values.put(Rows.Total.fullPrefixRow(RowPrefix.subtotalSurcharge, prefixPercent, prefixGlobal), this.surchargeSubtotal.toString());
                values.put(Rows.Counter.fullPrefixRow(RowPrefix.subtotalSurcharge, prefixPercent, prefixGlobal), this.surchargeSubtotalCounter);
                this.fm.getDbSource().saveData(Tables.fmGlobals.table(), values);
            }
            catch (SQLException e) {
                throw new FmStoreToDbException(e);
            }
        }
    }

    public BigDecimal getDiscountItem() {
        return this.discountItem;
    }

    public BigDecimal getDiscountSubtotal() {
        return this.discountSubtotal;
    }

    public BigDecimal getSurchargeItem() {
        return this.surchargeItem;
    }

    public BigDecimal getSurchargeSubtotal() {
        return this.surchargeSubtotal;
    }

    public int getDiscountItemCounter() {
        return this.discountItemCounter;
    }

    public int getSurchargeItemCounter() {
        return this.surchargeItemCounter;
    }

    public int getDiscountSubtotalCounter() {
        return this.discountSubtotalCounter;
    }

    public int getSurchargeSubtotalCounter() {
        return this.surchargeSubtotalCounter;
    }

    public BigDecimal getDiscountTotal() {
        return this.discountItem.add(this.discountSubtotal);
    }

    public int getDiscountTotalCount() {
        return this.discountItemCounter + this.discountSubtotalCounter;
    }

    public void appendDiscountItem(BigDecimal appendValue) throws FmStoreToDbException {
        this.discountItem = this.discountItem.add(appendValue);
        ++this.discountItemCounter;
        this.saveToDb();
    }

    public void appendSurchargeItem(BigDecimal appendValue) throws FmStoreToDbException {
        this.surchargeItem = this.surchargeItem.add(appendValue);
        ++this.surchargeItemCounter;
        this.saveToDb();
    }

    public void appendDiscountSubtotal(BigDecimal appendValue) throws FmStoreToDbException {
        this.discountSubtotal = this.discountSubtotal.add(appendValue);
        ++this.discountSubtotalCounter;
        this.saveToDb();
    }

    public void appendSurchargeSubtotal(BigDecimal appendValue) throws FmStoreToDbException {
        this.surchargeSubtotal = this.surchargeSubtotal.add(appendValue);
        ++this.surchargeSubtotalCounter;
        this.saveToDb();
    }

    public static class Builder {
        FmFiscalMemory fm;
        boolean global;
        boolean percent;
        BigDecimal discountItem = BigDecimal.ZERO;
        BigDecimal discountSubtotal = BigDecimal.ZERO;
        BigDecimal surchargeItem = BigDecimal.ZERO;
        BigDecimal surchargeSubtotal = BigDecimal.ZERO;
        int discountItemCounter = 0;
        int surchargeItemCounter = 0;
        int discountSubtotalCounter = 0;
        int surchargeSubtotalCounter = 0;

        public Builder(FmFiscalMemory fm, boolean global, boolean percent) {
            this.fm = fm;
            this.global = global;
            this.percent = percent;
        }

        public Builder setDiscountItem(BigDecimal discountItem) {
            this.discountItem = discountItem;
            return this;
        }

        public Builder setDiscountSubtotal(BigDecimal discountSubtotal) {
            this.discountSubtotal = discountSubtotal;
            return this;
        }

        public Builder setSurchargeItem(BigDecimal surchargeItem) {
            this.surchargeItem = surchargeItem;
            return this;
        }

        public Builder setSurchargeSubtotal(BigDecimal surchargeSubtotal) {
            this.surchargeSubtotal = surchargeSubtotal;
            return this;
        }

        public Builder setDiscountItemCounter(int discountItemCounter) {
            this.discountItemCounter = discountItemCounter;
            return this;
        }

        public Builder setSurchargeItemCounter(int surchargeItemCounter) {
            this.surchargeItemCounter = surchargeItemCounter;
            return this;
        }

        public Builder setDiscountSubtotalCounter(int discountSubtotalCounter) {
            this.discountSubtotalCounter = discountSubtotalCounter;
            return this;
        }

        public Builder setSurchargeSubtotalCounter(int surchargeSubtotalCounter) {
            this.surchargeSubtotalCounter = surchargeSubtotalCounter;
            return this;
        }

        public DiscountTurnover build() throws FmStoreToDbException {
            return new DiscountTurnover(this);
        }
    }
}

