/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.data;

import java.math.BigDecimal;
import java.sql.SQLException;
import sk.singularisdev.ekasask.enumeration.VAT_TYPE;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.db.enums.RowPrefix;
import sk.singularisdev.ekasask.fm.db.enums.Rows;
import sk.singularisdev.ekasask.fm.db.enums.Tables;
import sk.singularisdev.ekasask.fm.db.helpers.ContentValues;

public class Turnover {
    private FmFiscalMemory fm;
    private char level;
    private Integer vat;
    private BigDecimal localBase;
    private BigDecimal localVat;
    private BigDecimal localTotal;
    private BigDecimal globalBase;
    private BigDecimal globalVat;
    private BigDecimal globalTotal;
    private VAT_TYPE vatType;
    private String pattern = "LocalVat: %s, LocalBase: %s, LocalTotal: %s\nGlobalVat: %s, GlobalBase: %s, GlobalTotal: %s";

    public Turnover(Builder builder) {
        this.fm = builder.fm;
        this.level = builder.level;
        this.vat = builder.vat;
        this.localBase = builder.localBase;
        this.localVat = builder.localVat;
        this.localTotal = builder.localTotal;
        this.globalBase = builder.globalBase;
        this.globalVat = builder.globalVat;
        this.globalTotal = builder.globalTotal;
        this.vatType = builder.vatType;
    }

    public void tiltLocalToGlobal() throws FmStoreToDbException {
        this.globalBase = this.globalBase.add(this.localBase);
        this.globalVat = this.globalVat.add(this.localVat);
        this.globalTotal = this.globalTotal.add(this.localTotal);
        this.saveToDb();
    }

    public void appendLocalTotal(BigDecimal appendTotal) throws FmStoreToDbException {
        this.localTotal = this.localTotal.add(appendTotal);
        this.saveToDb();
    }

    public void setLocalTotal(BigDecimal localTotal) throws FmStoreToDbException {
        this.localTotal = localTotal;
        this.saveToDb();
    }

    public BigDecimal getLocalTotal() {
        return this.localTotal;
    }

    public void appendGlobalTotal(BigDecimal appendTotal) throws FmStoreToDbException {
        this.globalTotal = this.globalTotal.add(appendTotal);
        this.saveToDb();
    }

    public BigDecimal getGlobalTotal() {
        return this.globalTotal;
    }

    public void setLocalBase(BigDecimal localBase) throws FmStoreToDbException {
        this.localBase = localBase;
        this.saveToDb();
    }

    public BigDecimal getLocalBase() {
        return this.localBase;
    }

    public void appendGlobalBase(BigDecimal appendBase) throws FmStoreToDbException {
        this.globalBase = this.globalBase.add(appendBase);
        this.saveToDb();
    }

    public BigDecimal getGlobalBase() {
        return this.globalBase;
    }

    public void setVat(Integer vat) throws FmStoreToDbException {
        this.vat = vat;
        this.saveToDb();
    }

    public void setVatType(VAT_TYPE vatType) throws FmStoreToDbException {
        this.vatType = vatType;
        this.saveToDb();
    }

    public void setLocalVat(BigDecimal localVat) throws FmStoreToDbException {
        this.localVat = localVat;
        this.saveToDb();
    }

    public BigDecimal getLocalVat() {
        return this.localVat;
    }

    public void appendGlobalVat(BigDecimal appendVat) throws FmStoreToDbException {
        this.globalVat = this.globalVat.add(appendVat);
        this.saveToDb();
    }

    public BigDecimal getGlobalVat() {
        return this.globalVat;
    }

    public Integer getVat() {
        return this.vat;
    }

    public VAT_TYPE getVatType() {
        return this.vatType;
    }

    public void resetGlobals() throws FmStoreToDbException {
        this.globalBase = BigDecimal.ZERO;
        this.globalVat = BigDecimal.ZERO;
        this.globalTotal = BigDecimal.ZERO;
        this.saveToDb();
    }

    public void resetLocals() throws FmStoreToDbException {
        this.localBase = BigDecimal.ZERO;
        this.localVat = BigDecimal.ZERO;
        this.localTotal = BigDecimal.ZERO;
        this.saveToDb();
    }

    private void saveToDb() throws FmStoreToDbException {
        if (this.fm != null) {
            try {
                ContentValues values = new ContentValues();
                values.put(Rows.VATValue.row(), this.vat);
                values.put(Rows.VATType.row(), this.vatType == null ? null : this.vatType.name());
                values.put(Rows.Base.fullPrefixRow(RowPrefix.local), this.localBase.toString());
                values.put(Rows.VAT.fullPrefixRow(RowPrefix.local), this.localVat.toString());
                values.put(Rows.Total.fullPrefixRow(RowPrefix.local), this.localTotal.toString());
                values.put(Rows.Base.fullPrefixRow(RowPrefix.global), this.globalBase.toString());
                values.put(Rows.VAT.fullPrefixRow(RowPrefix.global), this.globalVat.toString());
                values.put(Rows.Total.fullPrefixRow(RowPrefix.global), this.globalTotal.toString());
                this.fm.getDbSource().saveData(Tables.fmVats.table(), values, String.valueOf(Rows.IdChar.row()) + "='" + this.level + "'");
            }
            catch (SQLException e) {
                throw new FmStoreToDbException(e);
            }
        }
    }

    public String toString() {
        return String.format(this.pattern, this.localVat, this.localBase, this.localTotal, this.globalVat, this.globalBase, this.globalTotal);
    }

    public static class Builder {
        FmFiscalMemory fm;
        char level;
        Integer vat = null;
        BigDecimal localBase = BigDecimal.ZERO;
        BigDecimal localVat = BigDecimal.ZERO;
        BigDecimal localTotal = BigDecimal.ZERO;
        BigDecimal globalBase = BigDecimal.ZERO;
        BigDecimal globalVat = BigDecimal.ZERO;
        BigDecimal globalTotal = BigDecimal.ZERO;
        VAT_TYPE vatType = null;

        public Builder(FmFiscalMemory fm, char level) {
            this.fm = fm;
            this.level = level;
        }

        public Builder setVatType(VAT_TYPE vatType) {
            this.vatType = vatType;
            return this;
        }

        public Builder setVat(Integer vat) {
            this.vat = vat;
            return this;
        }

        public Builder setLocals(BigDecimal localTotal, BigDecimal localVat, BigDecimal localBase) {
            this.localTotal = localTotal;
            this.localVat = localVat;
            this.localBase = localBase;
            return this;
        }

        public Builder setGlobals(BigDecimal globalTotal, BigDecimal globalVat, BigDecimal globalBase) {
            this.globalTotal = globalTotal;
            this.globalVat = globalVat;
            this.globalBase = globalBase;
            return this;
        }

        public Turnover build() {
            return new Turnover(this);
        }
    }
}

