/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.db;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import sk.singularisdev.ekasask.enumeration.BARCODE_FONT_SIZE;
import sk.singularisdev.ekasask.enumeration.BARCODE_TEXT_POSITION;
import sk.singularisdev.ekasask.enumeration.VAT_TYPE;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.data.DiscountTurnover;
import sk.singularisdev.ekasask.fm.data.NegativeTurnover;
import sk.singularisdev.ekasask.fm.data.ParagonModel;
import sk.singularisdev.ekasask.fm.data.PaymentMethod;
import sk.singularisdev.ekasask.fm.data.Turnover;
import sk.singularisdev.ekasask.fm.db.FmDBHelper;
import sk.singularisdev.ekasask.fm.db.enums.DB;
import sk.singularisdev.ekasask.fm.db.enums.RowPrefix;
import sk.singularisdev.ekasask.fm.db.enums.Rows;
import sk.singularisdev.ekasask.fm.db.enums.Tables;
import sk.singularisdev.ekasask.fm.db.helpers.ContentValues;
import sk.singularisdev.ekasask.fm.db.helpers.Cursor;
import sk.singularisdev.ekasask.fm.db.helpers.SQLiteDatabase;
import sk.singularisdev.ekasask.fm.db.holder.DbFmData;
import sk.singularisdev.ekasask.fm.db.holder.DbFmState;
import sk.singularisdev.ekasask.fm.enums.ParagonType;
import sk.singularisdev.ekasask.fm.util.SerializationUtility;

public class FiscalDataStorage {
    private SQLiteDatabase database;
    private FmDBHelper dbHelper;
    private String createFormat = "yyyy-MM-dd HH:mm:ss";
    private boolean transactionActive = false;

    public FiscalDataStorage(long deviceId) {
        this.dbHelper = new FmDBHelper((int)deviceId);
    }

    public boolean open() {
        if (this.dbHelper != null) {
            this.database = this.dbHelper.getWritableDatabase();
            return true;
        }
        return false;
    }

    public boolean isDbOK() {
        if (this.database == null) {
            return false;
        }
        return this.database.isOpen();
    }

    public void beginTransaction() {
        this.database.beginTransaction();
        this.transactionActive = true;
    }

    public void succes() {
        this.database.success();
    }

    public void endTransaction() {
        this.database.endTransaction();
        this.transactionActive = false;
    }

    public void close() {
        if (this.dbHelper != null) {
            this.dbHelper.close();
        }
    }

    public boolean isTransactionActive() {
        return this.transactionActive;
    }

    public PaymentMethod getPaymentMethod(FmFiscalMemory fm, int ID) throws FmStoreToDbException {
        try (Cursor cursor = null;){
            String[] columns = new String[]{Rows.FmId.row(), Rows.PaymentName.row(), Rows.PaymentMinCurrency.row(), Rows.PaymentOverpay.row(), Rows.Total.fullPrefixRow(RowPrefix.local), Rows.Total.fullPrefixRow(RowPrefix.global), Rows.Total.fullPrefixRow(RowPrefix.exchange, RowPrefix.local), Rows.Total.fullPrefixRow(RowPrefix.exchange, RowPrefix.global), Rows.Total.fullPrefixRow(RowPrefix.deposite, RowPrefix.local), Rows.Total.fullPrefixRow(RowPrefix.deposite, RowPrefix.global), Rows.Total.fullPrefixRow(RowPrefix.withdraw, RowPrefix.local), Rows.Total.fullPrefixRow(RowPrefix.withdraw, RowPrefix.global), Rows.Counter.fullPrefixRow(RowPrefix.local), Rows.Counter.fullPrefixRow(RowPrefix.global), Rows.Counter.fullPrefixRow(RowPrefix.deposite, RowPrefix.local), Rows.Counter.fullPrefixRow(RowPrefix.deposite, RowPrefix.global), Rows.Counter.fullPrefixRow(RowPrefix.withdraw, RowPrefix.local), Rows.Counter.fullPrefixRow(RowPrefix.withdraw, RowPrefix.global)};
            cursor = this.database.query(Tables.fmPayments.table(), columns, String.valueOf(Rows.FmId.row()) + "=" + ID, null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                if (!cursor.isAfterLast()) {
                    PaymentMethod paymentMethod = new PaymentMethod.Builder(fm).setFmId(cursor.getInt(0)).setName(cursor.getString(1)).setMinCurrency(cursor.getString(2)).setOverpay(cursor.getInt(3) != 0).setLocalTurnover(new BigDecimal(cursor.getString(4))).setGlobalTurnover(new BigDecimal(cursor.getString(5))).setExchangeLocalTurnover(new BigDecimal(cursor.getString(6))).setExchangeGlobalTurnover(new BigDecimal(cursor.getString(7))).setLocalDeposite(new BigDecimal(cursor.getString(8))).setGlobalDeposite(new BigDecimal(cursor.getString(9))).setLocalWithdraw(new BigDecimal(cursor.getString(10))).setGlobalWithdraw(new BigDecimal(cursor.getString(11))).setLocalPaymentCounter(cursor.getInt(12)).setPaymentCounter(cursor.getInt(13)).setLocalDepositeCounter(cursor.getInt(14)).setDepositeCounter(cursor.getInt(15)).setLocalWithdrawCounter(cursor.getInt(16)).setWithdrawCounter(cursor.getInt(17)).build();
                    return paymentMethod;
                }
            }
            try {
                throw new SQLException("No data");
            }
            catch (SQLException e) {
                throw new FmStoreToDbException(e);
            }
        }
    }

    public char getParagonType(UUID uuid) throws FmStoreToDbException {
        Cursor cursor = null;
        try {
            cursor = this.database.query(Tables.fmJournal.table(), new String[]{Rows.ReceiptType.row()}, String.valueOf(Rows.UUID.row()) + "='" + uuid.toString() + "'", null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getChar(0);
            }
            throw new SQLException("No data");
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public long appendReceiptTotal(BigDecimal value) throws SQLException {
        return 0L;
    }

    public long saveJournalEntry(UUID uuid, int status, Integer month, Integer year, Integer pcd, String uid, String transactionId) throws SQLException {
        ContentValues values = new ContentValues();
        values.put(Rows.Status.row(), status);
        values.put(Rows.PCD_MONTH.row(), month);
        values.put(Rows.PCD_YEAR.row(), year);
        values.put(Rows.PCD_NUMERICAL.row(), pcd);
        values.put(Rows.UID.row(), uid);
        values.put(Rows.transactionId.row(), transactionId);
        return this.database.update(Tables.fmJournal.table(), values, String.valueOf(Rows.UUID.row()) + "='" + uuid.toString() + "'");
    }

    public long saveJournalEntry(UUID uuid, int status, Integer month, Integer year, Integer pcd, String uid, String okp, String pkp, String qrCode, byte[] copyData, int receiptNumber, int reportNumber, String transactionId) throws SQLException {
        ContentValues values = new ContentValues();
        values.put(Rows.Status.row(), status);
        values.put(Rows.PCD_MONTH.row(), month);
        values.put(Rows.PCD_YEAR.row(), year);
        values.put(Rows.PCD_NUMERICAL.row(), pcd);
        values.put(Rows.UID.row(), uid);
        values.put(Rows.OKP.row(), okp);
        values.put(Rows.PKP.row(), pkp);
        values.put(Rows.QR_CODE.row(), qrCode);
        values.put(Rows.Print.row(), copyData);
        values.put(Rows.fmReceiptNumber.row(), receiptNumber);
        values.put(Rows.fmReportNumber.row(), reportNumber);
        values.put(Rows.transactionId.row(), transactionId);
        return this.database.update(Tables.fmJournal.table(), values, String.valueOf(Rows.UUID.row()) + "='" + uuid.toString() + "'");
    }

    public long createJournalEntry(UUID uuid, Date created, byte[] binaryData, char receiptType, String customTransactionId) throws SQLException {
        ContentValues values = new ContentValues();
        values.put(Rows.Created.row(), new SimpleDateFormat(this.createFormat).format(created));
        values.put(Rows.UUID.row(), uuid.toString());
        values.put(Rows.Binary.row(), binaryData);
        values.put(Rows.Confirmed.row(), 0);
        values.put(Rows.ReceiptType.row(), receiptType);
        values.put(Rows.customTransactionId.row(), customTransactionId);
        return this.database.insertOrThrow(Tables.fmJournal.table(), null, values);
    }

    public long confirmJournalEntry(UUID uuid) throws SQLException {
        ContentValues values = new ContentValues();
        values.put(Rows.Confirmed.row(), 1);
        return this.database.update(Tables.fmJournal.table(), values, String.valueOf(Rows.UUID.row()) + "='" + uuid.toString() + "'");
    }

    public void savePaymentDefinition(int fmId, String name, BigDecimal minCoin, boolean overpay) throws SQLException {
        ContentValues values = new ContentValues();
        values.put(Rows.PaymentName.row(), name);
        values.put(Rows.PaymentMinCurrency.row(), minCoin.toString());
        values.put(Rows.PaymentOverpay.row(), overpay ? 1 : 0);
        long id = this.database.update(Tables.fmPayments.table(), values, String.valueOf(Rows.FmId.row()) + "=" + fmId);
        if (id == -1L) {
            throw new SQLException("No update");
        }
    }

    public void saveData(String table, ContentValues values) throws SQLException {
        this.saveData(table, values, null);
    }

    public void saveData(String table, ContentValues values, String where) throws SQLException {
        long id = this.database.update(table, values, where);
        if (id == -1L) {
            throw new SQLException("No update");
        }
    }

    public DbFmData loadData() throws FmStoreToDbException {
        DbFmData data = new DbFmData();
        try (Cursor cursor = null;){
            cursor = this.database.query(Tables.fmData.table(), null, null, null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                data.setActualRow(cursor.getInt(0));
                data.setPassword(cursor.getString(1));
                data.setPrinterType(cursor.getInt(2));
                data.setPrinterBaud(cursor.getInt(3));
                data.setAdditionalHeader(cursor.getString(4));
                data.setAdditionalFooter(cursor.getString(5));
                data.setHeader(cursor.getString(6).split("\\n"));
                data.setGT(new BigDecimal(cursor.getString(7)));
                data.setReportNumber(cursor.getInt(8));
                data.setReceiptNumber(cursor.getInt(9));
                data.setPreline(cursor.getString(10));
                data.setPostline(cursor.getString(11));
                data.setReceiptNumberSFS(cursor.getString(12));
                data.setUID(cursor.getString(13));
                data.setOKP(cursor.getString(14));
                data.setReceiptTotal(new BigDecimal(cursor.getString(15)));
                try {
                    data.setLastPPEKKError(cursor.getInt(16).intValue());
                }
                catch (Exception e) {
                    data.setLastPPEKKError(0L);
                }
                try {
                    data.setLastDbError(cursor.getInt(17).intValue());
                }
                catch (Exception e) {
                    data.setLastDbError(0L);
                }
                data.setCharCount(cursor.getInt(18));
                data.setTextPos(BARCODE_TEXT_POSITION.valueOf((String)cursor.getString(19)));
                data.setTextFont(BARCODE_FONT_SIZE.valueOf((String)cursor.getString(20)));
                data.setBarcodeH(cursor.getInt(21));
                data.setBarcodeW(cursor.getInt(22));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    data.setLastShiftDate(sdf.parse(cursor.getString(24)));
                }
                catch (Exception e) {
                    data.setLastShiftDate(null);
                }
                try {
                    data.setLastReportDate(sdf.parse(cursor.getString(25)));
                }
                catch (Exception e) {
                    data.setLastReportDate(null);
                }
                try {
                    data.setLastReceiptUUID(UUID.fromString(cursor.getString(31)));
                }
                catch (Exception e) {
                    data.setLastReceiptUUID(null);
                }
                data.setQR(cursor.getString(32));
                data.setPKP(cursor.getString(33));
                data.setTransactionID(cursor.getString(34));
                data.setEmailDirectory(cursor.getString(35));
                data.setJournalZFlag(cursor.getString(36));
                data.setLastSFSError(cursor.getInt(37).intValue());
            }
            cursor.close();
            String[] columns = new String[]{Rows.Total.fullPrefixRow(RowPrefix.invoice), Rows.Counter.fullPrefixRow(RowPrefix.invoice), Rows.Counter.fullPrefixRow(RowPrefix.deposite, RowPrefix.withdraw), Rows.Total.fullPrefixRow(RowPrefix.invalidReceipt), Rows.Counter.fullPrefixRow(RowPrefix.invalidReceipt), Rows.Total.fullPrefixRow(RowPrefix.invoice, RowPrefix.local)};
            cursor = this.database.query(Tables.fmGlobals.table(), columns, null, null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                data.setInvoiceTurnover(new BigDecimal(cursor.getString(0)));
                data.setInvoiceCounter(cursor.getInt(1));
                data.setDepositeWithdrawCount(cursor.getInt(2));
                data.setInvalidReceiptTotal(new BigDecimal(cursor.getString(3)));
                data.setInvalidReceiptCount(cursor.getInt(4));
                data.setLocalInvoiceTurnover(new BigDecimal(cursor.getString(5)));
            }
            DbFmData dbFmData = data;
            return dbFmData;
        }
    }

    public DbFmState loadFmState() throws FmStoreToDbException {
        try (Cursor cursor = null;){
            String[] columns = new String[]{Rows.fmState.row(), Rows.fmGPVatPayer.row(), Rows.fmGPSafeMode.row(), Rows.fmException48.row()};
            cursor = this.database.query(Tables.fmStates.table(), columns, null, null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                if (!cursor.isAfterLast()) {
                    DbFmState dbFmState = new DbFmState(cursor.getInt(0), cursor.getInt(1) == 0, cursor.getInt(2) != 0, cursor.getInt(3) != 0);
                    return dbFmState;
                }
            }
            try {
                throw new SQLException("No data");
            }
            catch (SQLException e) {
                throw new FmStoreToDbException(e);
            }
        }
    }

    public ParagonModel loadParagon() throws FmStoreToDbException {
        try (Cursor cursor = null;){
            String[] columns = new String[]{Rows.fmParagon.row()};
            cursor = this.database.query(Tables.fmData.table(), columns, null, null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                if (!cursor.isAfterLast()) {
                    String serializedData = cursor.getString(0);
                    if (serializedData == null) {
                        return null;
                    }
                    ParagonModel paragonModel = (ParagonModel)SerializationUtility.fromString(serializedData);
                    return paragonModel;
                }
            }
            try {
                throw new SQLException("No data");
            }
            catch (IOException e) {
                throw new FmStoreToDbException(e);
            }
            catch (ClassNotFoundException e) {
                throw new FmStoreToDbException(e);
            }
            catch (SQLException e) {
                throw new FmStoreToDbException(e);
            }
        }
    }

    public DiscountTurnover loadDiscountTurnover(FmFiscalMemory fm, boolean global, boolean percent) throws FmStoreToDbException {
        try (Cursor cursor = null;){
            RowPrefix prefixGlobal = global ? RowPrefix.global : RowPrefix.local;
            RowPrefix prefixPercent = percent ? RowPrefix.percent : RowPrefix.value;
            String[] columns = new String[]{Rows.Total.fullPrefixRow(RowPrefix.discount, prefixPercent, prefixGlobal), Rows.Counter.fullPrefixRow(RowPrefix.discount, prefixPercent, prefixGlobal), Rows.Total.fullPrefixRow(RowPrefix.surcharge, prefixPercent, prefixGlobal), Rows.Counter.fullPrefixRow(RowPrefix.surcharge, prefixPercent, prefixGlobal), Rows.Total.fullPrefixRow(RowPrefix.subtotalDiscount, prefixPercent, prefixGlobal), Rows.Counter.fullPrefixRow(RowPrefix.subtotalDiscount, prefixPercent, prefixGlobal), Rows.Total.fullPrefixRow(RowPrefix.subtotalSurcharge, prefixPercent, prefixGlobal), Rows.Counter.fullPrefixRow(RowPrefix.subtotalSurcharge, prefixPercent, prefixGlobal)};
            cursor = this.database.query(Tables.fmGlobals.table(), columns, null, null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                if (!cursor.isAfterLast()) {
                    DiscountTurnover discountTurnover = new DiscountTurnover.Builder(fm, global, percent).setDiscountItem(new BigDecimal(cursor.getString(0))).setDiscountItemCounter(cursor.getInt(1)).setSurchargeItem(new BigDecimal(cursor.getString(2))).setSurchargeItemCounter(cursor.getInt(3)).setDiscountSubtotal(new BigDecimal(cursor.getString(4))).setDiscountSubtotalCounter(cursor.getInt(5)).setSurchargeSubtotal(new BigDecimal(cursor.getString(6))).setSurchargeSubtotalCounter(cursor.getInt(7)).build();
                    return discountTurnover;
                }
            }
            try {
                throw new FmStoreToDbException("No data");
            }
            catch (SQLException e) {
                throw new FmStoreToDbException(e);
            }
        }
    }

    public NegativeTurnover loadNegativeTurnover(FmFiscalMemory fm, boolean global) throws FmStoreToDbException {
        try (Cursor cursor = null;){
            RowPrefix prefixGlobal = global ? RowPrefix.global : RowPrefix.local;
            String[] columns = new String[]{Rows.Total.fullPrefixRow(RowPrefix.itemVoid, prefixGlobal), Rows.Counter.fullPrefixRow(RowPrefix.itemVoid, prefixGlobal), Rows.Total.fullPrefixRow(RowPrefix.itemReturn, prefixGlobal), Rows.Counter.fullPrefixRow(RowPrefix.itemReturn, prefixGlobal), Rows.Total.fullPrefixRow(RowPrefix.itemNegative, prefixGlobal), Rows.Counter.fullPrefixRow(RowPrefix.itemNegative, prefixGlobal), Rows.Total.fullPrefixRow(RowPrefix.itemDestroy, prefixGlobal), Rows.Counter.fullPrefixRow(RowPrefix.itemDestroy, prefixGlobal), Rows.Total.fullPrefixRow(RowPrefix.round, prefixGlobal), Rows.Counter.fullPrefixRow(RowPrefix.round, prefixGlobal)};
            cursor = this.database.query(Tables.fmGlobals.table(), columns, null, null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                if (!cursor.isAfterLast()) {
                    NegativeTurnover negativeTurnover = new NegativeTurnover.Builder(fm, global).setVoidValue(new BigDecimal(cursor.getString(0))).setVoidCount(cursor.getInt(1)).setReturnValue(new BigDecimal(cursor.getString(2))).setReturnCount(cursor.getInt(3)).setNegativeValue(new BigDecimal(cursor.getString(4))).setNegativeCount(cursor.getInt(5)).setDestroyedValue(new BigDecimal(cursor.getString(6))).setDestroyedCount(cursor.getInt(7)).setRoundValue(new BigDecimal(cursor.getString(8))).setRoundCount(cursor.getInt(9)).build();
                    return negativeTurnover;
                }
            }
            try {
                throw new FmStoreToDbException("No data");
            }
            catch (SQLException e) {
                throw new FmStoreToDbException(e);
            }
        }
    }

    public Turnover loadVatTurnover(FmFiscalMemory fm, char level) throws FmStoreToDbException {
        try (Cursor cursor = null;){
            String[] columns = new String[]{Rows.VATValue.row(), Rows.VATType.row(), Rows.Base.fullPrefixRow(RowPrefix.local), Rows.VAT.fullPrefixRow(RowPrefix.local), Rows.Total.fullPrefixRow(RowPrefix.local), Rows.Base.fullPrefixRow(RowPrefix.global), Rows.VAT.fullPrefixRow(RowPrefix.global), Rows.Total.fullPrefixRow(RowPrefix.global)};
            cursor = this.database.query(Tables.fmVats.table(), columns, String.valueOf(Rows.IdChar.row()) + "='" + level + "'", null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                if (!cursor.isAfterLast()) {
                    Turnover turnover = new Turnover.Builder(fm, level).setVat(cursor.getInt(0)).setVatType(VAT_TYPE.getVatType((String)cursor.getString(1))).setLocals(new BigDecimal(cursor.getString(4)), new BigDecimal(cursor.getString(3)), new BigDecimal(cursor.getString(2))).setGlobals(new BigDecimal(cursor.getString(7)), new BigDecimal(cursor.getString(6)), new BigDecimal(cursor.getString(5))).build();
                    return turnover;
                }
            }
            try {
                throw new FmStoreToDbException("No data");
            }
            catch (SQLException e) {
                throw new FmStoreToDbException(e);
            }
        }
    }

    public String exportParagonIDs(int type, String whereParam) throws SQLException {
        String[] columns = new String[]{Rows.transactionId.row(), Rows.customTransactionId.row(), Rows.QR_CODE.row(), Rows.UID.row()};
        Cursor cursor = null;
        switch (type) {
            case 0: {
                cursor = this.database.query(Tables.fmJournal.table(), columns, String.valueOf(Rows.QR_CODE.row()) + " != ''", null, null, String.valueOf(Rows.Created.row()) + " DESC", "1");
                break;
            }
            case 1: {
                cursor = this.database.query(Tables.fmJournal.table(), columns, String.valueOf(Rows.transactionId.row()) + " = '" + whereParam + "'", null, null, null, null);
                break;
            }
            case 2: {
                cursor = this.database.query(Tables.fmJournal.table(), columns, String.valueOf(Rows.customTransactionId.row()) + " = '" + whereParam + "'", null, null, null, null);
                break;
            }
            case 3: {
                cursor = this.database.query(Tables.fmJournal.table(), columns, String.valueOf(Rows.UID.row()) + " = '" + whereParam + "'", null, null, null, null);
                break;
            }
            case 4: {
                cursor = this.database.query(Tables.fmJournal.table(), columns, String.valueOf(Rows.PCD_YEAR.row()) + "=" + Integer.parseInt(whereParam.substring(0, 4)) + " AND " + Rows.PCD_MONTH.row() + "=" + Integer.parseInt(whereParam.substring(4, 6)) + " AND " + Rows.PCD_NUMERICAL.row() + "=" + Integer.parseInt(whereParam.substring(6)), null, null, null, null);
            }
        }
        if (cursor.getCount() > 0) {
            cursor.moveToFirst();
            return String.valueOf(cursor.getString(0)) + ";" + cursor.getString(1) + ";" + cursor.getString(2) + ";" + cursor.getString(3);
        }
        throw new SQLException("No data");
    }

    /*
     * Unable to fully structure code
     */
    public byte[] exportJournal(ParagonType type, String dateFrom, String dateTo, String path, String fileName) throws SQLException, IOException {
        block10: {
            columns = new String[]{Rows.Print.row(), Rows.Binary.row()};
            stream = new ByteArrayOutputStream();
            cursor = null;
            cursor = type == null || type == ParagonType.all ? this.database.query(Tables.fmJournal.table(), columns, String.valueOf(Rows.Created.row()) + " BETWEEN '" + dateFrom + "' AND '" + dateTo + "'", null, null, null, null) : this.database.query(Tables.fmJournal.table(), columns, String.valueOf(Rows.ReceiptType.row()) + " = '" + type.getType() + "' AND " + Rows.Created.row() + " BETWEEN '" + dateFrom + "' AND '" + dateTo + "'", null, null, null, null);
            if (cursor == null || cursor.getCount() <= 0) break block10;
            outputPrint = null;
            outputBinary = null;
            try {
                block11: {
                    cursor.moveToFirst();
                    stream.reset();
                    if (path == null || fileName == null) ** GOTO lbl30
                    file = new File(path);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    outputPrint = new BufferedOutputStream(new FileOutputStream(String.valueOf(path) + "/" + fileName + ".print"));
                    outputBinary = new BufferedOutputStream(new FileOutputStream(String.valueOf(path) + "/" + fileName + ".binary"));
                    while (!cursor.isAfterLast()) {
                        outputPrint.write(cursor.getBlob(0));
                        stream.write(cursor.getBlob(0));
                        outputBinary.write(cursor.getBlob(1));
                        cursor.moveToNext();
                    }
                    break block11;
lbl-1000:
                    // 1 sources

                    {
                        stream.write(cursor.getBlob(0));
                        cursor.moveToNext();
lbl30:
                        // 2 sources

                        ** while (!cursor.isAfterLast())
                    }
                }
                var13_13 = stream.toByteArray();
                return var13_13;
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
            finally {
                if (outputPrint != null) {
                    outputPrint.close();
                }
                if (outputBinary != null) {
                    outputBinary.close();
                }
                stream.close();
            }
        }
        throw new SQLException("No data");
    }

    public String exportJournalZ(String flagDate, String path, String fileName) throws SQLException, IOException {
        String[] columns = new String[]{Rows.Print.row(), Rows.Binary.row(), Rows.Created.row()};
        Cursor cursor = null;
        boolean fullRevolve = false;
        OutputStream outputPrint = null;
        OutputStream outputBinary = null;
        String newDate = flagDate;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            try {
                outputPrint = new BufferedOutputStream(new FileOutputStream(String.valueOf(path) + "/" + fileName + ".print"));
                outputBinary = new BufferedOutputStream(new FileOutputStream(String.valueOf(path) + "/" + fileName + ".binary"));
                while (!fullRevolve) {
                    cursor = this.database.query(Tables.fmJournal.table(), columns, String.valueOf(Rows.Created.row()) + " > '" + newDate + "'", null, null, null, "50");
                    if (cursor != null && cursor.getCount() > 0) {
                        cursor.moveToFirst();
                        while (!cursor.isAfterLast()) {
                            outputPrint.write(cursor.getBlob(0));
                            outputBinary.write(cursor.getBlob(1));
                            newDate = cursor.getString(2);
                            cursor.moveToNext();
                        }
                        continue;
                    }
                    fullRevolve = true;
                }
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        }
        finally {
            if (outputPrint != null) {
                outputPrint.close();
            }
            if (outputBinary != null) {
                outputBinary.close();
            }
        }
        return newDate;
    }

    public byte[] exportJournal(DB type, String searchInput, String path, String fileName) throws SQLException, IOException, NumberFormatException {
        if (searchInput == null) {
            throw new SQLException("No data");
        }
        Cursor cursor = null;
        String[] columns = new String[]{Rows.Print.row(), Rows.Binary.row()};
        String where = "";
        switch (type) {
            case uuid: {
                where = String.valueOf(Rows.UUID.row()) + "='" + searchInput + "'";
                break;
            }
            case pcd: {
                where = String.valueOf(Rows.PCD_YEAR.row()) + "=" + Integer.parseInt(searchInput.substring(0, 4)) + " AND " + Rows.PCD_MONTH.row() + "=" + Integer.parseInt(searchInput.substring(4, 6)) + " AND " + Rows.PCD_NUMERICAL.row() + "=" + Integer.parseInt(searchInput.substring(6));
                break;
            }
            case okp: {
                where = String.valueOf(Rows.OKP.row()) + "='" + searchInput + "'";
                break;
            }
            case uid: {
                where = String.valueOf(Rows.UID.row()) + "='" + searchInput + "'";
                break;
            }
            case oldPcd: {
                where = String.valueOf(Rows.fmReceiptNumber.row()) + "=" + Integer.parseInt(searchInput.substring(5, 10)) + " AND " + Rows.fmReportNumber.row() + "=" + Integer.parseInt(searchInput.substring(0, 5));
            }
        }
        byte[] printOut = new byte[]{32};
        cursor = this.database.query(Tables.fmJournal.table(), columns, where, null, null, null, null);
        if (cursor.getCount() > 0) {
            cursor.moveToFirst();
            if (path != null && fileName != null) {
                try (OutputStream output = null;){
                    File file = new File(path);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    output = new BufferedOutputStream(new FileOutputStream(String.valueOf(path) + "/" + fileName + ".print"));
                    printOut = cursor.getBlob(0);
                    output.write(printOut);
                    output.close();
                    output = new BufferedOutputStream(new FileOutputStream(String.valueOf(path) + "/" + fileName + ".binary"));
                    output.write(cursor.getBlob(1));
                    output.close();
                }
            } else {
                return cursor.getBlob(0);
            }
            cursor.close();
        }
        return printOut;
    }

    public boolean isTransactionInUse(String transactionId) throws SQLException {
        Cursor cursor = this.database.query(Tables.fmJournal.table(), new String[]{Rows.customTransactionId.row()}, String.valueOf(Rows.customTransactionId.row()) + " = '" + transactionId + "'", null, null, null, null);
        if (cursor.getCount() > 0) {
            cursor.close();
            return true;
        }
        cursor.close();
        return false;
    }
}

