/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.db;

import java.math.BigDecimal;
import java.sql.SQLException;
import sk.singularisdev.ekasask.enumeration.VAT_TYPE;
import sk.singularisdev.ekasask.fm.db.DbConstructors;
import sk.singularisdev.ekasask.fm.db.enums.RowPrefix;
import sk.singularisdev.ekasask.fm.db.enums.Rows;
import sk.singularisdev.ekasask.fm.db.enums.Tables;
import sk.singularisdev.ekasask.fm.db.helpers.SQLiteDatabase;
import sk.singularisdev.ekasask.fm.db.helpers.SQLiteOpenHelper;

public class FmDBHelper
extends SQLiteOpenHelper {
    private static final String FOREIGN_KEYS_ENABLE = "PRAGMA foreign_keys = ON;";
    private static final String ENCODING_UTF8 = "PRAGMA encoding = 'UTF-8'";
    private static final int VERSION = 100;
    private static final String DB_NAME = "FmDb_%d.db";

    FmDBHelper(int deviceId) {
        super(String.format(DB_NAME, deviceId), 100);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        try {
            db.execSQL(FOREIGN_KEYS_ENABLE);
            db.execSQL(ENCODING_UTF8);
            db.execSQL(DbConstructors.CREATE_DB_FM_STATES);
            db.execSQL(DbConstructors.CREATE_DB_FM_DATA);
            db.execSQL(DbConstructors.CREATE_DB_VAT_DATA);
            db.execSQL(DbConstructors.CREATE_DB_PAYMENT_DATA);
            db.execSQL(DbConstructors.CREATE_DB_GLOBALS_DATA);
            db.execSQL(DbConstructors.CREATE_DB_JOURNAL_DATA);
            db.execSQL(DbConstructors.INSERT_DB_FM_STATES);
            db.execSQL(DbConstructors.INSERT_DB_FM_DATA);
            this.insertVat(db, 'A', 20, VAT_TYPE.BASED);
            this.insertVat(db, 'B', 10, VAT_TYPE.REDUCED);
            this.insertVat(db, 'C', 0, VAT_TYPE.FREE);
            this.insertVat(db, 'D', null, null);
            this.insertVat(db, 'E', null, null);
            this.insertPayment(db, 1, "Karta", new BigDecimal("0.01"), false);
            this.insertPayment(db, 2, "\u0160ek", new BigDecimal("0.01"), false);
            this.insertPayment(db, 3, "Stravn\u00e9 l\u00ed", new BigDecimal("0.01"), false);
            this.insertPayment(db, 4, "Zahr.mena", new BigDecimal("0.01"), true);
            this.insertPayment(db, 5, "PLATIDLO 5", new BigDecimal("0.01"), true);
            this.insertPayment(db, 6, "PLATIDLO 6", new BigDecimal("0.01"), true);
            this.insertPayment(db, 7, "PLATIDLO 7", new BigDecimal("0.01"), true);
            this.insertPayment(db, 8, "PLATIDLO 8", new BigDecimal("0.01"), true);
            this.insertPayment(db, 16, "Hotovos\u0165", new BigDecimal("0.01"), true);
            db.execSQL(DbConstructors.INSERT_DB_GLOBALS);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void insertVat(SQLiteDatabase db, char level, Integer vat, VAT_TYPE type) throws SQLException {
        db.execSQL("INSERT INTO " + Tables.fmVats.table() + "(" + Rows.IdChar.row() + "," + Rows.VATValue.row() + "," + Rows.VATType.row() + "," + Rows.VAT.fullPrefixRow(RowPrefix.local) + "," + Rows.VAT.fullPrefixRow(RowPrefix.global) + "," + Rows.Base.fullPrefixRow(RowPrefix.local) + "," + Rows.Base.fullPrefixRow(RowPrefix.global) + "," + Rows.Total.fullPrefixRow(RowPrefix.local) + "," + Rows.Total.fullPrefixRow(RowPrefix.global) + ") VALUES (" + "'" + level + "'" + "," + vat + "," + (type == null ? "null" : "'" + type.name() + "'") + "," + "'0.00'" + "," + "'0.00'" + "," + "'0.00'" + "," + "'0.00'" + "," + "'0.00'" + "," + "'0.00'" + ");");
    }

    private void insertPayment(SQLiteDatabase db, int paymentId, String name, BigDecimal minCoin, boolean overpay) throws SQLException {
        db.execSQL("INSERT INTO " + Tables.fmPayments.table() + "(" + Rows.FmId.row() + "," + Rows.PaymentName.row() + "," + Rows.PaymentMinCurrency.row() + "," + Rows.PaymentOverpay.row() + "," + Rows.Total.fullPrefixRow(RowPrefix.local) + "," + Rows.Total.fullPrefixRow(RowPrefix.global) + "," + Rows.Total.fullPrefixRow(RowPrefix.exchange, RowPrefix.local) + "," + Rows.Total.fullPrefixRow(RowPrefix.exchange, RowPrefix.global) + "," + Rows.Total.fullPrefixRow(RowPrefix.deposite, RowPrefix.local) + "," + Rows.Total.fullPrefixRow(RowPrefix.deposite, RowPrefix.global) + "," + Rows.Total.fullPrefixRow(RowPrefix.withdraw, RowPrefix.local) + "," + Rows.Total.fullPrefixRow(RowPrefix.withdraw, RowPrefix.global) + "," + Rows.Counter.fullPrefixRow(RowPrefix.local) + "," + Rows.Counter.fullPrefixRow(RowPrefix.global) + "," + Rows.Counter.fullPrefixRow(RowPrefix.deposite, RowPrefix.local) + "," + Rows.Counter.fullPrefixRow(RowPrefix.deposite, RowPrefix.global) + "," + Rows.Counter.fullPrefixRow(RowPrefix.withdraw, RowPrefix.local) + "," + Rows.Counter.fullPrefixRow(RowPrefix.withdraw, RowPrefix.global) + ") VALUES (" + paymentId + "," + "'" + name + "'" + "," + "'" + minCoin.toString() + "'" + "," + (overpay ? "1" : "0") + "," + "'0.00'" + "," + "'0.00'" + "," + "'0.00'" + "," + "'0.00'" + "," + "'0.00'" + "," + "'0.00'" + "," + "'0.00'" + "," + "'0.00'" + "," + "0" + "," + "0" + "," + "0" + "," + "0" + "," + "0" + "," + "0" + ");");
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.setVersion(newVersion);
    }

    @Override
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.setVersion(newVersion);
    }
}

