/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.db.helpers;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cursor {
    private List<Map<Integer, Object>> cursor = new ArrayList<Map<Integer, Object>>();
    private int cursorIndex = 0;

    private List<Map<Integer, Object>> resultSetToList(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        ArrayList<Map<Integer, Object>> rows = new ArrayList<Map<Integer, Object>>();
        while (rs.next()) {
            HashMap<Integer, Object> row = new HashMap<Integer, Object>(columns);
            int i = 0;
            while (i < columns) {
                row.put(i, rs.getObject(i + 1));
                ++i;
            }
            rows.add(row);
        }
        return rows;
    }

    public Cursor(ResultSet resultSet) throws SQLException {
        this.cursor = this.resultSetToList(resultSet);
    }

    public Long getLong(int index) {
        return (Long)this.cursor.get(this.cursorIndex).get(index);
    }

    public Integer getInt(int index) {
        return (Integer)this.cursor.get(this.cursorIndex).get(index);
    }

    public String getString(int index) {
        return (String)this.cursor.get(this.cursorIndex).get(index);
    }

    public byte[] getBlob(int index) {
        return (byte[])this.cursor.get(this.cursorIndex).get(index);
    }

    public char getChar(int index) {
        return ((String)this.cursor.get(this.cursorIndex).get(index)).charAt(0);
    }

    public boolean moveToFirst() {
        if (this.cursor.size() == 0) {
            return false;
        }
        this.cursorIndex = 0;
        return true;
    }

    public boolean moveToNext() {
        if (this.cursor.size() == 0) {
            return false;
        }
        ++this.cursorIndex;
        return true;
    }

    public boolean isAfterLast() {
        if (this.cursor.size() == 0) {
            return true;
        }
        return this.cursor.size() <= this.cursorIndex;
    }

    public int getCount() {
        return this.cursor.size();
    }

    public void close() {
        if (this.cursor.size() != 0) {
            this.cursor = new ArrayList<Map<Integer, Object>>();
        }
    }
}

