/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.db.helpers;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.fm.db.helpers.ContentValues;
import sk.singularisdev.ekasask.fm.db.helpers.Cursor;

public final class SQLiteDatabase {
    private static final Logger logger = LoggerManager.getLogger((String)SQLiteDatabase.class.getName());
    private static final String DIRECTORY = "DB";
    private Connection db = null;
    private boolean dbOK = false;
    private boolean transactionSucces = false;
    private String dbPath;

    public SQLiteDatabase(String dbPath, int version) throws SQLException {
        this.dbPath = dbPath;
    }

    public synchronized boolean open() {
        try {
            if (this.db != null) {
                this.close();
            }
            this.db = DriverManager.getConnection("jdbc:sqlite:" + this.dbPath);
            Statement statement = this.db.createStatement();
            statement.execute("PRAGMA main.page_size = 4096");
            statement.execute("PRAGMA main.cache_size=10000");
            statement.execute("PRAGMA main.locking_mode=EXCLUSIVE");
            statement.execute("PRAGMA main.synchronous=NORMAL");
            statement.execute("PRAGMA main.journal_mode=WAL");
            statement.execute("PRAGMA main.cache_size=5000");
            this.dbOK = true;
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.db = null;
            this.dbOK = false;
            return false;
        }
    }

    public synchronized void close() {
        try {
            if (this.db != null) {
                this.db.close();
            }
            this.dbOK = false;
        }
        catch (SQLException e) {
            this.dbOK = false;
            this.db = null;
        }
    }

    public void deleteDatabase(String dbName) {
        File f = new File(DIRECTORY, String.valueOf(dbName) + ".db");
        if (f.exists() && f.isFile()) {
            f.delete();
        }
    }

    public boolean isOpen() {
        return this.dbOK;
    }

    public synchronized int update(String table, ContentValues values, String whereClause) {
        String sqlQuery;
        block14: {
            sqlQuery = "";
            if (values != null && !values.isEmpty()) break block14;
            return -1;
        }
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE ");
            sql.append(table);
            sql.append(" SET ");
            Object[] bindArgs = new Object[values.size()];
            int i = 0;
            for (String colName : values.keySet()) {
                sql.append(i > 0 ? "," : "");
                sql.append(colName);
                Object value = values.get(colName);
                if (value == null) {
                    sql.append("=null");
                } else {
                    sql.append("=?");
                    bindArgs[i++] = value;
                }
                logger.debug("\t" + colName + "=" + value);
            }
            if (whereClause != null && whereClause.length() != 0) {
                sql.append(" WHERE ");
                sql.append(whereClause);
            }
            sqlQuery = sql.toString();
            logger.debug(sqlQuery);
            PreparedStatement statement = this.db.prepareStatement(sqlQuery);
            i = 1;
            Object[] objectArray = bindArgs;
            int n = bindArgs.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                if (value instanceof String) {
                    statement.setString(i, (String)value);
                } else if (value instanceof Integer) {
                    statement.setInt(i, (Integer)value);
                } else if (value instanceof byte[]) {
                    statement.setBytes(i, (byte[])value);
                } else {
                    logger.fatal("unknown data type " + value);
                }
                ++i;
                ++n2;
            }
            int updatedRows = statement.executeUpdate();
            statement.close();
            return updatedRows;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public synchronized void beginTransaction() {
        if (this.db != null) {
            try {
                this.db.setAutoCommit(false);
                this.transactionSucces = false;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void success() {
        this.transactionSucces = true;
    }

    public synchronized void endTransaction() {
        try {
            if (this.db != null) {
                if (this.transactionSucces) {
                    this.db.commit();
                } else {
                    this.db.rollback();
                }
                this.db.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public synchronized long insertOrThrow(String table, String nullColumnHack, ContentValues values) throws SQLException {
        if (values == null || values.isEmpty()) {
            return -1L;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(table);
        sql.append("(");
        Object[] bindArgs = null;
        int size = values.size();
        int i = 0;
        if (size > 0) {
            StringBuilder sbValues = new StringBuilder();
            bindArgs = new Object[values.size()];
            for (String colName : values.keySet()) {
                sql.append(i > 0 ? "," : "");
                sql.append(colName);
                sbValues.append(i > 0 ? "," : "");
                Object value = values.get(colName);
                if (value == null) {
                    sbValues.append("NULL");
                    continue;
                }
                sbValues.append("?");
                bindArgs[i++] = value;
            }
            sql.append(")");
            sql.append(" VALUES (");
            sql.append(sbValues.toString());
        } else {
            sql.append(String.valueOf(nullColumnHack) + ") VALUES (NULL");
        }
        sql.append(")");
        PreparedStatement statement = this.db.prepareStatement(sql.toString(), 1);
        statement.setQueryTimeout(30);
        i = 1;
        Object[] objectArray = bindArgs;
        int n = bindArgs.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof String) {
                statement.setString(i, (String)value);
            } else if (value instanceof Integer) {
                statement.setInt(i, (Integer)value);
            } else if (value instanceof byte[]) {
                statement.setBytes(i, (byte[])value);
            } else {
                logger.fatal("unknown data type " + value);
            }
            ++i;
            ++n2;
        }
        int autoIncKeyValue = statement.executeUpdate();
        statement.close();
        return autoIncKeyValue;
    }

    public synchronized int delete(String table, String whereClause) {
        try {
            PreparedStatement statement = this.db.prepareStatement("DELETE FROM " + table + (whereClause != null && whereClause.length() != 0 ? " WHERE " + whereClause : ""));
            int index = statement.executeUpdate();
            statement.close();
            return index;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public synchronized Cursor query(String table, String[] columns, String where, String groupBy, String having, String orderBy, String limit) throws SQLException {
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ");
            if (columns != null && columns.length != 0) {
                this.appendColumns(query, columns);
            } else {
                query.append("* ");
            }
            query.append("FROM ");
            query.append(table);
            SQLiteDatabase.appendClause(query, " WHERE ", where);
            SQLiteDatabase.appendClause(query, " GROUP BY ", groupBy);
            SQLiteDatabase.appendClause(query, " HAVING ", having);
            SQLiteDatabase.appendClause(query, " ORDER BY ", orderBy);
            SQLiteDatabase.appendClause(query, " LIMIT ", limit);
            Statement statement = this.db.createStatement();
            String sqlQuery = query.toString();
            logger.debug(sqlQuery);
            Cursor cursor = new Cursor(statement.executeQuery(sqlQuery));
            statement.close();
            return cursor;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized void execSQL(String sql) throws SQLException {
        try (Statement statement = this.db.createStatement();){
            statement.execute(sql);
            statement.close();
        }
    }

    public synchronized int getVersion() {
        if (this.db != null) {
            try {
                Statement statement = this.db.createStatement();
                ResultSet query = statement.executeQuery("PRAGMA user_version;");
                if (query != null && query.getInt(1) != 0) {
                    int version = query.getInt(1);
                    statement.close();
                    return version;
                }
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public synchronized void setVersion(int version) {
        try {
            this.execSQL("PRAGMA user_version = " + version);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void appendClause(StringBuilder s, String name, String clause) {
        if (clause != null && clause.length() != 0) {
            s.append(name);
            s.append(clause);
        }
    }

    private void appendColumns(StringBuilder s, String[] columns) {
        int n = columns.length;
        int i = 0;
        while (i < n) {
            String column = columns[i];
            if (column != null) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(column);
            }
            ++i;
        }
        s.append(' ');
    }
}

