/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.test.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.ErrorListenerInterface;
import sk.singularisdev.ekasask.fm.Daemon;
import sk.singularisdev.ekasask.fm.config.Config;
import sk.singularisdev.ekasask.fm.interfaces.GUIThreadListener;
import sk.singularisdev.ekasask.fm.test.ui.DisabledPanel;
import sk.singularisdev.ekasask.fm.test.ui.GUIParserRunnable;

public class MainFrame
extends JFrame
implements ActionListener,
GUIThreadListener {
    private static final long serialVersionUID = 1L;
    private String fileExtension;
    private File path;
    private Config config;
    private Map<JButton, File> buttons = new HashMap<JButton, File>();
    private DisabledPanel disabledPanel;
    public static Logger logger = LoggerManager.getLogger((String)MainFrame.class.getName());

    public MainFrame(File path, Config config, String fileExtension) {
        this.config = config;
        this.path = path;
        this.fileExtension = fileExtension;
        this.init();
    }

    private void init() {
        this.setBounds(0, 0, 816, 639);
        this.setTitle("CHDU CERTIFICATION TOOL");
        JPanel mainPanel = new JPanel(null);
        this.disabledPanel = new DisabledPanel(mainPanel);
        this.add(this.disabledPanel);
        List<File> files = Arrays.asList(this.path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith("." + MainFrame.this.fileExtension);
            }
        }));
        this.setDefaultCloseOperation(0);
        Collections.sort(files);
        int x = 0;
        int y = 0;
        if (files != null) {
            for (File file : files) {
                JButton btn = new JButton("<html>" + file.getName().replaceAll(" ", "<br>") + "</html>");
                btn.setBounds(x, y, 200, 100);
                btn.addActionListener(this);
                this.buttons.put(btn, file);
                mainPanel.add(btn);
                if ((x += 200) <= 600) continue;
                x = 0;
                y += 100;
            }
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.disabledPanel.setSpinningMessage("Ukon\u010dujem");
                MainFrame.this.disabledPanel.setEnabled(false);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Daemon.getInstance().uninstall();
                        MainFrame.this.disabledPanel.setEnabled(true);
                        MainFrame.this.dispose();
                        System.exit(0);
                    }
                }).start();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (this.buttons.containsKey(source)) {
            this.disabledPanel.setSpinningMessage("Spracov\u00e1vam");
            this.disabledPanel.setEnabled(false);
            new Thread(new GUIParserRunnable(this.config, this.buttons.get(source), this)).start();
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println("JAVA VERSION: " + System.getProperty("java.version"));
            Configuration.setErrorListener((ErrorListenerInterface)new ErrorListenerInterface(){

                public void errorException(Exception e) {
                    block13: {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
                        FileOutputStream fos = null;
                        try {
                            try {
                                File dir = new File("exception_error_log");
                                if (!dir.exists()) {
                                    dir.mkdirs();
                                }
                                File file = new File(dir, "exception_error_" + sdf.format(new Date()) + "_" + (int)(Math.random() * 100000.0) + ".log");
                                file.createNewFile();
                                fos = new FileOutputStream(file);
                                fos.write(e.getMessage().getBytes("UTF-8"));
                                fos.flush();
                            }
                            catch (Exception ex) {
                                logger.fatal("Error save log", (Throwable)e);
                                if (fos == null) break block13;
                                try {
                                    fos.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        finally {
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                }

                public void httpErrorListener(String response) {
                    block13: {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
                        FileOutputStream fos = null;
                        try {
                            try {
                                File dir = new File("http_error_log");
                                if (!dir.exists()) {
                                    dir.mkdirs();
                                }
                                File file = new File(dir, "http_error_" + sdf.format(new Date()) + "_" + (int)(Math.random() * 100000.0) + ".log");
                                file.createNewFile();
                                fos = new FileOutputStream(file);
                                fos.write(response.getBytes("UTF-8"));
                                fos.flush();
                            }
                            catch (Exception e) {
                                logger.fatal("Error save log", (Throwable)e);
                                if (fos == null) break block13;
                                try {
                                    fos.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        finally {
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                }
            });
            Config config = new Config();
            if (args != null) {
                String[] stringArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    if (arg.contains("-port:")) {
                        try {
                            config.setSuperserver(Integer.parseInt(arg.split(":")[1]));
                        }
                        catch (Exception e) {
                            config.setSuperserver(30000);
                        }
                    } else if (arg.contains("-log:")) {
                        switch (arg.split(":")[1].charAt(0)) {
                            case 'A': {
                                config.setLogging(Level.ALL);
                                break;
                            }
                            case 'I': {
                                config.setLogging(Level.INFO);
                            }
                        }
                    } else if (arg.contains("-folder:")) {
                        try {
                            config.setPath(arg.split(":")[1]);
                        }
                        catch (Exception e) {
                            config.setPath("");
                        }
                    } else if (arg.contains("-url:")) {
                        Configuration.setSfsUrl((String)arg.split(":")[1]);
                    } else if (arg.contains("-proxy:")) {
                        String[] proxy = arg.split(":");
                        Configuration.setProxyHost((String)proxy[1]);
                        Configuration.setProxyPort((int)Integer.parseInt(proxy[2]));
                    }
                    ++n2;
                }
            } else {
                config.setSuperserver(30000);
            }
            Daemon.getInstance().install(config);
            File path = new File(config.getPath());
            MainFrame mainFrame = new MainFrame(path, config, "pri");
            mainFrame.setVisible(true);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            Daemon.logger.error("", (Throwable)e);
            Daemon.getInstance().uninstall();
            System.exit(0);
        }
    }

    @Override
    public void processFinished(boolean success) {
        if (this.disabledPanel != null) {
            this.disabledPanel.setEnabled(true);
        }
    }
}

