/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.eKasaSK.lib;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import sk.singularisdev.eKasaSK.lib.FMDataFileListener;
import sk.singularisdev.eKasaSK.lib.FMDataStringListener;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterface;
import sk.singularisdev.eKasaSK.lib.Pegas06FMException;
import sk.singularisdev.eKasaSK.lib.communication.CommunicationDriver;

public class LowLevelFMInterfaceNoControl
extends LowLevelFMInterface {
    public LowLevelFMInterfaceNoControl() {
    }

    public LowLevelFMInterfaceNoControl(CommunicationDriver serial) {
        super(serial);
    }

    public void paragonBegin(int deviceNumber, String rowNumber, String saleType, String communicationType, String paragonType, String recapitulationType, String graphicHeader, String correctionTransactionID) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 32, rowNumber, saleType, communicationType, paragonType, recapitulationType, graphicHeader, correctionTransactionID);
    }

    public void paragonBegin(int deviceNumber, String rowNumber, String saleType, String communicationType, String paragonType, String recapitulationType, String graphicHeader) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 32, rowNumber, saleType, communicationType, paragonType, recapitulationType, graphicHeader, null);
    }

    public void paragonEnd(int deviceNumber, String rowNumber, String graphicHeader) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 34, rowNumber, graphicHeader);
    }

    public void sellingDayBegin(int deviceNumber, String saleMode) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 41, saleMode);
    }

    public void itemSale(int deviceNumber, String rowNumber, String commodityName, String totalPrice, String vat, String amount, String unitPrice, String unit) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 36, rowNumber, commodityName, totalPrice, vat, amount, unitPrice, unit);
    }

    public void itemVoid(int deviceNumber, String rowNumber, String commodityName, String totalPrice, String vat, String amount, String unitPrice, String unit, String referenceDocumentNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 37, rowNumber, commodityName, totalPrice, vat, amount, unitPrice, unit, referenceDocumentNumber);
    }

    public void itemReturn(int deviceNumber, String rowNumber, String commodityName, String totalPrice, String vat, String amount, String unitPrice, String unit, String referenceDocumentNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 40, rowNumber, commodityName, totalPrice, vat, amount, unitPrice, unit, referenceDocumentNumber);
    }

    public void itemNegative(int deviceNumber, String rowNumber, String commodityName, String totalPrice, String vat, String amount, String unitPrice, String unit) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 45, rowNumber, commodityName, totalPrice, vat, amount, unitPrice, unit);
    }

    public void itemDiscount(int deviceNumber, String rowNumber, String description, String operationType, String discountValue, String vat) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 38, rowNumber, description, operationType, discountValue, vat);
    }

    public void itemDiscount2(int deviceNumber, String rowNumber, String description, String operationType, String discountValue, String vat, String discountTotalValue) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 52, rowNumber, description, operationType, discountValue, vat, discountTotalValue);
    }

    public void subTotal(int deviceNumber, String rowNumber, String description, String operationType) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 39, rowNumber, description, operationType);
    }

    public void payment(int deviceNumber, String rowNumber, String paymentNumber, String total, String payedAmount, String exchangeRate, String description) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 48, rowNumber, paymentNumber, total, payedAmount, exchangeRate, description);
    }

    public void payment2(int deviceNumber, String rowNumber, String paymentNumber, String total, String payedAmount, String exchangeRate, String description, String totalPayedAmount) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 54, rowNumber, paymentNumber, total, payedAmount, exchangeRate, description, totalPayedAmount);
    }

    public void destroyParagon(int deviceNumber, String rowNumber, String description) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 43, rowNumber, description);
    }

    public void subTotalDiscount(int deviceNumber, String rowNumber, String description, String operationType, String discountValue, String vat) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 44, rowNumber, description, operationType, discountValue, vat);
    }

    public void subTotalDiscount2(int deviceNumber, String rowNumber, String description, String operationType, String discountValue, String discountTotalValue, String vat) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 53, rowNumber, description, operationType, discountValue, discountTotalValue, vat);
    }

    public void printAnnouncement(int deviceNumber, String rowNumber, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 49, rowNumber, text);
    }

    public void printAnnouncementNF(int deviceNumber, String rowNumber, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 50, rowNumber, text);
    }

    public void printDisplay(int deviceNumber, String displayType, String escSequence, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 197, displayType, escSequence, text);
    }

    public void clearDisplay(int deviceNumber, String displayType, String escSequence) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 198, displayType, escSequence);
    }

    @Override
    public void setEscapeSequence(int deviceNumber, String sequence) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 199, sequence);
    }

    public void depositeInDrawer(int deviceNumber, String rowNumber, String description, String operationType, String amount, String paymentNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 46, rowNumber, description, operationType, amount, paymentNumber);
    }

    public void printDisplay2(int deviceNumber, String displayType, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 200, displayType, text);
    }

    public void printBC(int deviceNumber, String codeType, String code) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 55, codeType, code);
    }

    public void freeID(int deviceNumber, String print, String freeId) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 56, print, freeId);
    }

    public void setQrParm(int deviceNumber, String model, String moduleWidth, String correctionLevel, String leftMargin, String viewMode) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 236, model, moduleWidth, correctionLevel, leftMargin, viewMode);
    }

    public void setHeader(int deviceNumber, String password, String rowNumber, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 188, password, rowNumber, text);
    }

    @Override
    public void setAdditionalHeader(int deviceNumber, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 193, text);
    }

    @Override
    public void setAdditionalFooter(int deviceNumber, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 194, text);
    }

    @Override
    public void setPreline(int deviceNumber, String description) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 195, description);
    }

    @Override
    public void setPostline(int deviceNumber, String description) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 196, description);
    }

    @Override
    public void fiscalization(int deviceNumber, String password, String dkp) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 176, password, dkp);
    }

    @Override
    public void setDateTime(int deviceNumber, String date) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 191, date);
    }

    public void setVAT(int deviceNumber, String password, String vat, String vatValue, String reverseConstant) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 190, password, vat, vatValue, reverseConstant);
    }

    public void setParameter(int deviceNumber, String password, String paramNumber, String paramValue) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 189, password, paramNumber, paramValue);
    }

    public void setV48(int deviceNumber, String password, String stateV48) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 164, password, stateV48);
    }

    public void loadGHMMC(int deviceNumber, String imageNumber, String leftSpacing) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 208, imageNumber, leftSpacing);
        if (this.graphicHeadersMMC.get(imageNumber) == null) {
            this.blockOut(new byte[4], true);
        } else {
            this.blockOut((byte[])this.graphicHeadersMMC.get(imageNumber), true);
        }
    }

    public void loadGHNV(int deviceNumber, int imageCount, String leftSpacing1, String leftSpacing2, String leftSpacing3, String leftSpacing4, String leftSpacing5, String leftSpacing6) throws Pegas06FMException {
        byte[][] imageStreams = new byte[7][];
        int imageNumber = 1;
        while (imageNumber <= imageCount) {
            imageStreams[imageNumber] = this.graphicHeadersNV.get(imageNumber) == null ? new byte[4] : (byte[])this.graphicHeadersNV.get(imageNumber);
            ++imageNumber;
        }
        this.executionCommand(deviceNumber, 209, "" + imageCount, String.valueOf(leftSpacing1) + leftSpacing2 + leftSpacing3 + leftSpacing4 + leftSpacing5 + leftSpacing6);
        byte[] data = this.byteArray.toByteArray();
        this.dataOut(data);
        int imageNumber2 = 1;
        while (imageNumber2 <= imageCount) {
            if (imageNumber2 == imageCount) {
                this.blockOut(imageStreams[imageNumber2], true);
            } else {
                this.blockOut(imageStreams[imageNumber2], false);
            }
            ++imageNumber2;
        }
    }

    public void loadBitMap(int deviceNumber, String imageNumber, String leftSpacing) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 208, imageNumber, leftSpacing);
        if (this.graphicHeadersMMC.get(imageNumber) == null) {
            this.blockOut(new byte[4], true);
        } else {
            this.blockOut((byte[])this.graphicHeadersMMC.get(imageNumber), true);
        }
    }

    public void setEuroExchangeRate(int deviceNumber, String exchangeRate) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 178, exchangeRate);
    }

    public void setPaymentType(int deviceNumber, String paymentTypeNumber, String minCurrency, String overPay) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 187, paymentTypeNumber, minCurrency, overPay);
    }

    public void setPaymentType2(int deviceNumber, String paymentTypeName, String paymentTypeNumber, String minCurrency, String overPay) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 184, paymentTypeName, paymentTypeNumber, minCurrency, overPay);
    }

    @Override
    public void setPassword(int deviceNumber, String oldPassword, String newPassword) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 183, oldPassword, newPassword);
    }

    public void setPrinterType(int deviceNumber, String servicePassword, String printerType, String speed) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 182, servicePassword, printerType, speed);
    }

    public void setPRNBd(int deviceNumber, String speed) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 180, speed);
    }

    public void setBCparm(int deviceNumber, String textPosition, String textFont, String height, String width) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 213, textPosition, textFont, height, width);
    }

    public void setDKP(int deviceNumber, String password, String dkp) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 211, password, dkp);
    }

    public void setPParameter(int deviceNumber, String password, String paramType, String value) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 214, password, paramType, value);
    }

    public void setPRNcolumns(int deviceNumber, String width) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 216, width);
    }

    public void setDeltaSI(int deviceNumber, String password, String days) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 218, password, days);
    }

    public void setDispF(int deviceNumber, String password, String displayType, String displayProfile, String parameters) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 219, password, displayType, displayProfile, parameters);
    }

    public void setBluetooth(int deviceNumber, String bluetooth) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 250, bluetooth);
    }

    public void printReport(int deviceNumber, String reportType, String reportNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 80, reportType, reportNumber);
    }

    public String getJournal(int deviceNumber, String journalType, String journalNumber) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 159, dataListener, journalType, journalNumber);
        return dataListener.getData();
    }

    public String getStructJournalD(int deviceNumber, String journalType, String dateFrom, String dateTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 151, dataListener, journalType, dateFrom, dateTo);
        return dataListener.getData();
    }

    public String getStructJournalZ(int deviceNumber, String numberFrom, String numberTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 152, dataListener, numberFrom, numberTo);
        return dataListener.getData();
    }

    public void printStructJournalD(int deviceNumber, String journalType, String dateFrom, String dateTo) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 87, journalType, dateFrom, dateTo);
    }

    public void printStructJournalZ(int deviceNumber, String numberFrom, String numberTo) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 88, numberFrom, numberTo);
    }

    public String getJournalStructD1(int deviceNumber, String journalType, String dateFrom, String dateTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 154, dataListener, journalType, dateFrom, dateTo);
        return dataListener.getData();
    }

    public void printJournalStructD1(int deviceNumber, String journalType, String dateFrom, String dateTo) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 90, journalType, dateFrom, dateTo);
    }

    public String getJournalStructZ1(int deviceNumber, String docId, String numberFrom, String numberTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 155, dataListener, docId, numberFrom, numberTo);
        return dataListener.getData();
    }

    public String getJournalFATD1(int deviceNumber, String journalType, String dateFrom, String dateTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 160, dataListener, journalType, dateFrom, dateTo);
        return dataListener.getData();
    }

    public void printIntervalFPD(int deviceNumber, String printType, String dateFrom, String dateTo) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 82, printType, dateFrom, dateTo);
    }

    public void printIntervalFPC(int deviceNumber, String printType, String numberFrom, String numberTo) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 83, printType, numberFrom, numberTo);
    }

    public String getIntervalFPD(int deviceNumber, String printType, String dateFrom, String dateTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 156, dataListener, printType, dateFrom, dateTo);
        return dataListener.getData();
    }

    public String getIntervalFPC(int deviceNumber, String printType, String numberFrom, String numberTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 157, dataListener, printType, numberFrom, numberTo);
        return dataListener.getData();
    }

    public void verifyCRCElj(int deviceNumber, String closureNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 245, closureNumber);
    }

    public void inspectionE1(int deviceNumber, String password, String days) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 249, password, days);
    }

    public String getBCKP(int deviceNumber, String password, String page) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 121, dataListener, password, page);
        return dataListener.getData();
    }

    public void testPegasFM(int deviceNumber, String password, String device) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 122, password, device);
    }

    public void setPCHDU(int deviceNumber, String interfaceType, String name) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 205, interfaceType, name);
    }

    public void setLocation(int deviceNumber, String inputType, String ... parameters) throws Pegas06FMException {
        String[] data = new String[parameters.length + 1];
        data[0] = inputType;
        int i = 1;
        while (i < data.length) {
            data[i] = parameters[i - 1];
            ++i;
        }
        this.executionCommand(deviceNumber, 204, data);
    }

    public void setClientID(int deviceNumber, String number, String type) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 203, number, type);
    }

    public void printIssuedParagon(int deviceNumber, String serialNumber, String date) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 202, serialNumber, date);
    }

    @Override
    public void vymenaPoukazu(int deviceNumber, String name, String amount, String vat, String price, String voucherNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 192, name, amount, vat, price, voucherNumber);
    }

    public void odpocitanaZaloha(int deviceNumber, String name, String amount, String vat, String price) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 179, name, amount, vat, price);
    }

    public String getParagonIDs(int deviceNumber, String inputType, String input) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 175, dataListener, inputType, input);
        return dataListener.getData();
    }

    @Override
    public void openDrawer(int deviceNumber, int index) throws Pegas06FMException {
        switch (index) {
            case 1: {
                this.setEscapeSequence(deviceNumber, "~1B~70~00~20~80");
                break;
            }
            case 2: {
                this.setEscapeSequence(deviceNumber, "~1B~70~01~20~80");
            }
        }
    }

    public void saveIntervalFPD(int deviceNumber, String printType, String dateFrom, String dateTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 156, dataListener, printType, dateFrom, dateTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveIntervalFPC(int deviceNumber, String printType, String numberFrom, String numberTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 157, dataListener, printType, numberFrom, numberTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveBCKP(int deviceNumber, String password, String page, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(true);
            this.getCommand(deviceNumber, 121, dataListener, password, page);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void printJournal(int deviceNumber, String journalType, String journalNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 81, journalType, journalNumber);
    }

    public void saveJournalStructD1(int deviceNumber, String journalType, String dateFrom, String dateTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 154, dataListener, journalType, dateFrom, dateTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveJournalFATD1(int deviceNumber, String journalType, String dateFrom, String dateTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 160, dataListener, journalType, dateFrom, dateTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveJournalStructZ1(int deviceNumber, String docId, String numberFrom, String numberTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 155, dataListener, docId, numberFrom, numberTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveJournalToFile(int deviceNumber, String journalType, String journalNumber, String journalFile) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(journalFile);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 159, dataListener, journalType, journalNumber);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveStructJournalD(int deviceNumber, String journalType, String dateFrom, String dateTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 151, dataListener, journalType, dateFrom, dateTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveStructJournalN(int deviceNumber, String numberFrom, String numberTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 152, dataListener, numberFrom, numberTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }
}

