/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.eKasaSK.lib.communication.jserialcomm;

import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterface;
import sk.singularisdev.eKasaSK.lib.Pegas06FMException;
import sk.singularisdev.eKasaSK.lib.communication.CommunicationDriver;
import sk.singularisdev.eKasaSK.lib.communication.SerialCommunicationMirror;
import sk.singularisdev.eKasaSK.lib.languages.NoneLanguageMap;
import sk.singularisdev.eKasaSK.lib.logger.Logger;

public class SerialDriver
implements CommunicationDriver {
    NoneLanguageMap noneTranslate = new NoneLanguageMap();
    protected static Logger logger;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_2 = 3;
    public static final int STOPBITS_1_5 = 2;
    protected static final int RECV_TIMEOUT = 4000;
    protected static final int SEND_TIMEOUT = 4000;
    protected static final int BUFFER_SIZE = 16384;
    protected SerialPort serialPort;
    protected InputStream inStream;
    protected OutputStream outStream;
    private String port;
    private int baud;
    protected int stopBits = 1;
    protected boolean bufferEmpty = true;
    protected boolean init = false;
    protected List<SerialCommunicationMirror> mirrors = new ArrayList<SerialCommunicationMirror>();
    protected int recvTimeout = 4000;
    protected int sendTimeout = 4000;
    protected boolean xuseSignal = true;
    protected int waitBeforeOpen = 0;

    public SerialDriver(String port, int baud, int stopBits) {
        this(port, baud);
        this.stopBits = stopBits;
    }

    public SerialDriver(String port, int baud) {
        logger = Logger.createLogger(this.getClass().getName());
        this.init = false;
        this.port = port;
        this.baud = baud;
    }

    public SerialDriver(SerialPort serialPort) {
        logger = Logger.createLogger(this.getClass().getName());
        this.serialPort = serialPort;
        this.port = serialPort.getSystemPortName();
        this.baud = serialPort.getBaudRate();
        if (serialPort.openPort()) {
            this.inStream = this.serialPort.getInputStream();
            this.outStream = this.serialPort.getOutputStream();
            this.serialPort.setDTR();
            this.init = true;
        } else {
            this.init = false;
        }
    }

    public int getWaitBeforeOpen() {
        return this.waitBeforeOpen;
    }

    public void setWaitBeforeOpen(int waitBeforeOpen) {
        this.waitBeforeOpen = waitBeforeOpen;
    }

    @Override
    public int getBaud() {
        return this.baud;
    }

    public void setBaud(int baud) {
        this.baud = baud;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public void openPort() throws Pegas06FMException {
        logger.debug(String.valueOf(this.getPort()) + " - connecting ...");
        try {
            this.serialPort = SerialPort.getCommPort((String)this.getPort());
            if (!this.serialPort.openPort(this.waitBeforeOpen)) {
                this.init = false;
                throw new Pegas06FMException(-10101);
            }
            this.inStream = this.serialPort.getInputStream();
            this.outStream = this.serialPort.getOutputStream();
            this.serialPort.setFlowControl(17);
            this.serialPort.setComPortParameters(this.getBaud(), 8, this.stopBits, 0);
            this.serialPort.setComPortTimeouts(4352, this.recvTimeout, this.sendTimeout);
            this.serialPort.setDTR();
            this.init = true;
        }
        catch (Exception e) {
            this.init = false;
            logger.error(e.getMessage(), e);
            throw new Pegas06FMException(-10001, e);
        }
    }

    @Override
    public void closePort() {
        this.init = false;
        logger.debug(String.valueOf(this.getPort()) + " - disconnecting ...");
        try {
            logger.debug("Closing InputStream ...");
            this.inStream.close();
            logger.debug("Closing OutputStream ...");
            this.outStream.close();
            logger.debug("Closing SerialPort ...");
            this.serialPort.closePort();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
    }

    @Override
    public void send(byte[] data, LowLevelFMInterface signalInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        if (!this.serialPort.getCTS()) {
            throw new Pegas06FMException(-10103);
        }
        try {
            int i = 0;
            while (i < data.length) {
                logger.debug(" **** SerialSendData [bytes]:Waiting for empty buffer/ DSR");
                long time = System.currentTimeMillis();
                while (!this.bufferEmpty || !this.serialPort.getDSR()) {
                    logger.debug(" **** SerialSendData [bytes]:EmptyBuffer - " + this.bufferEmpty + "/ DSR:" + this.serialPort.getDSR());
                    if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                        throw new Pegas06FMException(-10006);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.outStream.write(data[i]);
                logger.debug(" **** SerialSendData [bytes]: writing byte [" + data[i]);
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteWritten(data[i]);
                }
                ++i;
            }
            logger.debug(" **** SerialSendData [bytes]: flush buffer *");
            logger.debug(" **** SerialSendData [bytes]: buffer flushed");
        }
        catch (IOException e) {
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void send(byte data, LowLevelFMInterface signalInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            logger.debug(" **** SerialSendData [byte]:Waiting for empty buffer/ DSR");
            long time = System.currentTimeMillis();
            while (!this.bufferEmpty || !this.serialPort.getDSR()) {
                logger.debug(" **** SerialSendData [byte]:EmptyBuffer - " + this.bufferEmpty + "/ DSR:" + this.serialPort.getDSR());
                if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                    throw new Pegas06FMException(-10006);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.outStream.write(data);
            logger.debug(" **** SerialSendData [byte]: writing byte [" + data);
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteWritten(data);
            }
            logger.debug(" **** SerialSendData [byte]: flush buffer");
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
    }

    public boolean isAvailable() throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            return this.inStream.available() > 0;
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public byte read(LowLevelFMInterface signalInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            long time = System.currentTimeMillis();
            logger.debug(" **** SerialRead: waiting for available data ");
            while (this.inStream.available() == 0) {
                Thread.sleep(5L);
                logger.debug(" **** SerialRead: waiting for CTS ");
                boolean longJob = false;
                signalInterface.invokeFMSignalListener(longJob);
                if (!this.serialPort.getCTS()) {
                    if (!longJob) {
                        longJob = !longJob;
                        signalInterface.invokeFMSignalListener(longJob);
                    }
                    time = System.currentTimeMillis();
                    continue;
                }
                if (longJob) {
                    longJob = !longJob;
                    signalInterface.invokeFMSignalListener(longJob);
                }
                logger.debug(" **** SerialRead: CTS ON ");
                if (time + (long)this.recvTimeout >= System.currentTimeMillis()) continue;
                throw new Pegas06FMException(64);
            }
            logger.debug(" **** SerialRead: read byte ");
            byte returnByte = (byte)this.inStream.read();
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteRead(returnByte);
            }
            logger.debug(" **** SerialRead: byte readed [" + returnByte);
            return returnByte;
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
        catch (InterruptedException e) {
            throw new Pegas06FMException(-10004, e);
        }
    }

    @Override
    public void clearInputBuffer() throws Exception {
        this.inStream.skip(this.inStream.available());
    }

    public static String[] getAvailableCommPorts() {
        SerialPort[] ports = SerialPort.getCommPorts();
        String[] portNames = new String[ports.length];
        int i = 0;
        while (i < ports.length) {
            SerialPort port = ports[i];
            portNames[i] = port.getSystemPortName();
            ++i;
        }
        return portNames;
    }

    @Override
    public void addMirror(SerialCommunicationMirror mirror) {
        this.mirrors.add(mirror);
    }

    @Override
    public void removeMirror(SerialCommunicationMirror mirror) {
        this.mirrors.remove(mirror);
    }

    @Override
    public void removeAllMirrors() {
        this.mirrors.clear();
    }

    @Override
    public boolean isInitialized() {
        return this.init;
    }

    @Override
    public void setOldFMBehaviour(boolean old) {
    }
}

