/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.eKasaSK.lib.communication.jserialcomm;

import com.fazecast.jSerialComm.SerialPort;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterface;
import sk.singularisdev.eKasaSK.lib.Pegas06FMException;
import sk.singularisdev.eKasaSK.lib.communication.SerialCommunicationMirror;
import sk.singularisdev.eKasaSK.lib.communication.jserialcomm.SerialDriver;

public class SerialDriverSwHandshake
extends SerialDriver {
    public SerialDriverSwHandshake(String port, int baud, int stopBits) {
        super(port, baud, stopBits);
    }

    public SerialDriverSwHandshake(String port, int baud) {
        super(port, baud);
    }

    public SerialDriverSwHandshake(SerialPort serialPort) {
        super(serialPort);
        serialPort.setDTR();
    }

    @Override
    public void openPort() throws Pegas06FMException {
        super.openPort();
        this.serialPort.setDTR();
    }

    @Override
    public void send(byte[] data, LowLevelFMInterface signalInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            logger.debug(" **** SerialSendData [bytes]:Waiting for empty buffer/ DSR");
            long time = System.currentTimeMillis();
            while (!this.bufferEmpty) {
                logger.debug(" **** SerialSendData [bytes]:EmptyBuffer - " + this.bufferEmpty);
                if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                    throw new Pegas06FMException(-10006);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int l = this.serialPort.writeBytes(data, (long)data.length);
            for (SerialCommunicationMirror mirror : this.mirrors) {
                int i = 0;
                while (i < l) {
                    mirror.byteWritten(data[i]);
                    ++i;
                }
            }
            if (l < data.length) {
                throw new Pegas06FMException(-10003);
            }
            logger.debug(" **** SerialSendData [bytes]: flush buffer *");
            logger.debug(" **** SerialSendData [bytes]: buffer flushed");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void send(byte data, LowLevelFMInterface signalInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        logger.debug(" **** SerialSendData [byte]:Waiting for empty buffer/ DSR");
        long time = System.currentTimeMillis();
        while (!this.bufferEmpty) {
            logger.debug(" **** SerialSendData [byte]:EmptyBuffer - " + this.bufferEmpty);
            if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                throw new Pegas06FMException(-10006);
            }
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] b = new byte[]{data};
        if (this.serialPort.writeBytes(b, 1L) != 1) {
            throw new Pegas06FMException(-10003);
        }
        logger.debug(" **** SerialSendData [byte]: writing byte [" + data);
        for (SerialCommunicationMirror mirror : this.mirrors) {
            mirror.byteWritten(data);
        }
        logger.debug(" **** SerialSendData [byte]: flush buffer");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public byte read(LowLevelFMInterface signalInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            time = System.currentTimeMillis();
            SerialDriverSwHandshake.logger.debug(" **** SerialRead: waiting for available data ");
            handshake = -1;
            longJob = false;
            while (this.serialPort.bytesAvailable() == 0) {
                Thread.sleep(5L);
                SerialDriverSwHandshake.logger.debug(" **** SerialRead: CTS ON ");
                if (time + (long)this.recvTimeout >= System.currentTimeMillis()) ** GOTO lbl-1000
                handshake = this.swHandshake(signalInterface);
                switch (handshake) {
                    case 19: {
                        handshake = -1;
                        time = System.currentTimeMillis();
                        longJob = true;
                        signalInterface.invokeFMSignalListener(longJob);
                        break;
                    }
                    case -1: 
                    case 17: {
                        throw new Pegas06FMException(64);
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        try {
                            Thread.sleep(100L);
                            break;
                        }
                        catch (Exception var6_6) {
                            // empty catch block
                        }
                    }
                }
            }
            if (longJob) {
                longJob = longJob == false;
                signalInterface.invokeFMSignalListener(longJob);
            }
            if (handshake == -1) {
                SerialDriverSwHandshake.logger.debug(" **** SerialRead: read byte ");
                b = new byte[1];
                l = this.serialPort.readBytes(b, 1L);
                returnByte = b[0];
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteRead(returnByte);
                }
                SerialDriverSwHandshake.logger.debug(" **** SerialRead: byte readed [" + returnByte);
            } else {
                returnByte = (byte)handshake;
            }
            return returnByte;
        }
        catch (InterruptedException e) {
            throw new Pegas06FMException(-10004, e);
        }
    }

    private int swHandshake(LowLevelFMInterface signalInterface) throws Pegas06FMException {
        logger.debug(" **** SerialHandshake");
        byte[] b = new byte[]{17};
        if (this.serialPort.writeBytes(b, 1L) < 1) {
            throw new Pegas06FMException(-10003);
        }
        logger.debug(" **** SerialHandshake: writing byte [17");
        for (SerialCommunicationMirror mirror : this.mirrors) {
            mirror.byteWritten((byte)17);
        }
        b = new byte[1];
        int l = this.serialPort.readBytes(b, 1L);
        int returnValue = l == 0 ? -1 : b[0];
        if (returnValue != -1) {
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteRead((byte)returnValue);
            }
        }
        return returnValue;
    }
}

