/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.eKasaSK.lib.communication.rxtx;

import gnu.io.SerialPort;
import java.io.IOException;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterface;
import sk.singularisdev.eKasaSK.lib.Pegas06FMException;
import sk.singularisdev.eKasaSK.lib.communication.SerialCommunicationMirror;
import sk.singularisdev.eKasaSK.lib.communication.rxtx.SerialDriver;

public class SerialDriverNoneHandshake
extends SerialDriver {
    public SerialDriverNoneHandshake(String port, int baud, int stopBits) {
        super(port, baud, stopBits);
    }

    public SerialDriverNoneHandshake(String port, int baud) {
        super(port, baud);
    }

    public SerialDriverNoneHandshake(SerialPort serialPort) {
        super(serialPort);
        serialPort.setDTR(false);
    }

    @Override
    public void openPort() throws Pegas06FMException {
        super.openPort();
        this.serialPort.setDTR(false);
    }

    @Override
    public void send(String s, String charsetName, LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        if (charsetName.equals("none")) {
            s = this.noneTranslate.convert(s);
            charsetName = "US-ASCII";
        }
        try {
            byte[] b = s.getBytes(charsetName);
            int i = 0;
            while (i < b.length) {
                long time = System.currentTimeMillis();
                while (!this.bufferEmpty) {
                    if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                        throw new Pegas06FMException(-10006);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.outStream.write(b[i]);
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteWritten(b[i]);
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void send(byte[] data, LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            int i = 0;
            while (i < data.length) {
                logger.debug(" **** SerialSendData [bytes]:Waiting for empty buffer/ DSR");
                long time = System.currentTimeMillis();
                while (!this.bufferEmpty) {
                    logger.debug(" **** SerialSendData [bytes]:EmptyBuffer - " + this.bufferEmpty + "/ DSR:" + this.serialPort.isDSR());
                    if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                        throw new Pegas06FMException(-10006);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.outStream.write(data[i]);
                logger.debug(" **** SerialSendData [bytes]: writing byte [" + data[i]);
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteWritten(data[i]);
                }
                ++i;
            }
            logger.debug(" **** SerialSendData [bytes]: flush buffer *");
            logger.debug(" **** SerialSendData [bytes]: buffer flushed");
        }
        catch (IOException e) {
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void send(byte data, LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            logger.debug(" **** SerialSendData [byte]:Waiting for empty buffer/ DSR");
            long time = System.currentTimeMillis();
            while (!this.bufferEmpty) {
                logger.debug(" **** SerialSendData [byte]:EmptyBuffer - " + this.bufferEmpty + "/ DSR:" + this.serialPort.isDSR());
                if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                    throw new Pegas06FMException(-10006);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.outStream.write(data);
            logger.debug(" **** SerialSendData [byte]: writing byte [" + data);
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteWritten(data);
            }
            logger.debug(" **** SerialSendData [byte]: flush buffer");
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void zsend(char c) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            long time = System.currentTimeMillis();
            while (!this.bufferEmpty) {
                if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                    throw new Pegas06FMException(-10006);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.outStream.write((byte)c);
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteWritten((byte)c);
            }
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public byte read(LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            long time = System.currentTimeMillis();
            logger.debug(" **** SerialRead: waiting for available data ");
            while (this.inStream.available() == 0) {
                Thread.sleep(5L);
                logger.debug(" **** SerialRead: waiting for CTS ");
                boolean longJob = false;
                fmInterface.invokeFMSignalListener(longJob);
                if (longJob) {
                    longJob = !longJob;
                    fmInterface.invokeFMSignalListener(longJob);
                }
                logger.debug(" **** SerialRead: CTS ON ");
                if (time + (long)this.recvTimeout >= System.currentTimeMillis()) continue;
                throw new Pegas06FMException(64);
            }
            logger.debug(" **** SerialRead: read byte ");
            byte returnByte = (byte)this.inStream.read();
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteRead(returnByte);
            }
            logger.debug(" **** SerialRead: byte readed [" + returnByte);
            return returnByte;
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
        catch (InterruptedException e) {
            throw new Pegas06FMException(-10004, e);
        }
    }
}

