/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.eKasaSK.lib.communication.rxtx;

import gnu.io.SerialPort;
import java.io.IOException;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterface;
import sk.singularisdev.eKasaSK.lib.Pegas06FMException;
import sk.singularisdev.eKasaSK.lib.communication.SerialCommunicationMirror;
import sk.singularisdev.eKasaSK.lib.communication.rxtx.SerialDriver;

public class SerialDriverSwHandshake
extends SerialDriver {
    public SerialDriverSwHandshake(String port, int baud, int stopBits) {
        super(port, baud, stopBits);
    }

    public SerialDriverSwHandshake(String port, int baud) {
        super(port, baud);
    }

    public SerialDriverSwHandshake(SerialPort serialPort) {
        super(serialPort);
        serialPort.setDTR(false);
    }

    @Override
    public void openPort() throws Pegas06FMException {
        super.openPort();
        this.serialPort.setDTR(false);
    }

    @Override
    public void send(String s, String charsetName, LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        if (charsetName.equals("none")) {
            s = this.noneTranslate.convert(s);
            charsetName = "US-ASCII";
        }
        try {
            byte[] b = s.getBytes(charsetName);
            int i = 0;
            while (i < b.length) {
                long time = System.currentTimeMillis();
                while (!this.bufferEmpty) {
                    if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                        throw new Pegas06FMException(-10006);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.outStream.write(b[i]);
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteWritten(b[i]);
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void send(byte[] data, LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            int i = 0;
            while (i < data.length) {
                logger.debug(" **** SerialSendData [bytes]:Waiting for empty buffer/ DSR");
                long time = System.currentTimeMillis();
                while (!this.bufferEmpty) {
                    logger.debug(" **** SerialSendData [bytes]:EmptyBuffer - " + this.bufferEmpty + "/ DSR:" + this.serialPort.isDSR());
                    if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                        throw new Pegas06FMException(-10006);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.outStream.write(data[i]);
                logger.debug(" **** SerialSendData [bytes]: writing byte [" + data[i]);
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteWritten(data[i]);
                }
                ++i;
            }
            logger.debug(" **** SerialSendData [bytes]: flush buffer *");
            logger.debug(" **** SerialSendData [bytes]: buffer flushed");
        }
        catch (IOException e) {
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void send(byte data, LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            logger.debug(" **** SerialSendData [byte]:Waiting for empty buffer/ DSR");
            long time = System.currentTimeMillis();
            while (!this.bufferEmpty) {
                logger.debug(" **** SerialSendData [byte]:EmptyBuffer - " + this.bufferEmpty + "/ DSR:" + this.serialPort.isDSR());
                if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                    throw new Pegas06FMException(-10006);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.outStream.write(data);
            logger.debug(" **** SerialSendData [byte]: writing byte [" + data);
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteWritten(data);
            }
            logger.debug(" **** SerialSendData [byte]: flush buffer");
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public byte read(LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            byte returnByte;
            long time = System.currentTimeMillis();
            logger.debug(" **** SerialRead: waiting for available data ");
            int handshake = -1;
            while (this.inStream.available() == 0) {
                Thread.sleep(5L);
                boolean longJob = false;
                fmInterface.invokeFMSignalListener(longJob);
                if (longJob) {
                    longJob = !longJob;
                    fmInterface.invokeFMSignalListener(longJob);
                }
                logger.debug(" **** SerialRead: CTS ON ");
                if (time + (long)this.recvTimeout >= System.currentTimeMillis()) continue;
                handshake = this.swHandshake(fmInterface);
                switch (handshake) {
                    case 19: {
                        handshake = -1;
                        time = System.currentTimeMillis();
                        break;
                    }
                    case -1: 
                    case 17: {
                        throw new Pegas06FMException(64);
                    }
                }
            }
            if (handshake == -1) {
                logger.debug(" **** SerialRead: read byte ");
                returnByte = (byte)this.inStream.read();
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteRead(returnByte);
                }
                logger.debug(" **** SerialRead: byte readed [" + returnByte);
            } else {
                returnByte = (byte)handshake;
            }
            return returnByte;
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
        catch (InterruptedException e) {
            throw new Pegas06FMException(-10004, e);
        }
    }

    private int swHandshake(LowLevelFMInterface fmInterface) throws Pegas06FMException {
        try {
            logger.debug(" **** SerialHandshake");
            this.outStream.write(17);
            logger.debug(" **** SerialHandshake: writing byte [17");
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteWritten((byte)17);
            }
            int returnValue = this.inStream.read();
            if (returnValue != -1) {
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteRead((byte)returnValue);
                }
            }
            return returnValue;
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
    }
}

