/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.io.IOException;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.interfaces.BlockOutInterface;
import sk.singularisdev.ekasask.fm.interfaces.DataGetInterface;

public abstract class FmCommand
implements Runnable {
    private static final Logger logger = LoggerManager.getLogger((String)FmCommand.class.getName());
    protected EKasa eKasa;
    protected String[] params;
    protected byte[] binary;
    protected AppCommunicationDriver driver;

    public FmCommand(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        this.eKasa = eKasa;
        this.params = params;
        this.binary = binary;
        this.driver = driver;
    }

    public void process() {
        this.run();
    }

    @Override
    public void run() {
        long t1 = -1L;
        long t2 = -1L;
        long t3 = -1L;
        long t4 = -1L;
        try {
            PPEKK ppekk = this.eKasa.getPPEKK();
            FmFiscalMemory fm = this.eKasa.getFm();
            t1 = System.currentTimeMillis();
            byte error = this.doCommand(ppekk, fm);
            t2 = System.currentTimeMillis();
            t3 = System.currentTimeMillis();
            if (error == 0) {
                if (this instanceof BlockOutInterface) {
                    this.driver.sendOk();
                    BlockOutInterface blockOut = (BlockOutInterface)((Object)this);
                    this.driver.readBlockData(blockOut);
                } else if (this instanceof DataGetInterface) {
                    DataGetInterface dataGet = (DataGetInterface)((Object)this);
                    dataGet.resetData();
                    boolean available = dataGet.isAvailableData();
                    while (available) {
                        byte[] data = dataGet.getNextData();
                        available = dataGet.isAvailableData();
                        this.driver.sendData(data, !available);
                    }
                } else {
                    this.driver.sendOk();
                }
            } else {
                this.driver.sendError(error);
            }
        }
        catch (IOException e) {
            logger.fatal("", (Throwable)e);
        }
        t4 = System.currentTimeMillis();
        logger.debug("COMMAND [" + this.getClass().getName() + "] Process:" + (t2 - t1) + "ms Commit:" + (t3 - t2) + "ms Response:" + (t4 - t3) + "ms Total:" + (t4 - t1) + "ms");
    }

    protected abstract byte doCommand(PPEKK var1, FmFiscalMemory var2);

    protected abstract byte parseParams();
}

