/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.internal.SetPrinterEsc;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.interfaces.DataGetInterface;
import sk.singularisdev.ekasask.fm.util.Hex;

public class GetEscapeSequence
extends FmCommand
implements DataGetInterface {
    private static final Logger logger = LoggerManager.getLogger((String)GetEscapeSequence.class.getName());
    private String esc;
    private int length;
    private byte[] dataOut;
    private boolean atEnd = true;

    public GetEscapeSequence(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block6: {
            byte status;
            block7: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block6;
                    status = this.parseParams();
                    if (status != 0) break block7;
                    try {
                        this.esc = this.esc.replaceAll("~", "");
                        SetPrinterEsc escSeq = SetPrinterEsc.getInstance((byte[])Formatter.get().decodeHexString(this.esc), (int)this.length);
                        ppekk.process((AbstractCommand)escSeq);
                        this.dataOut = escSeq.getResponse().getResponse();
                    }
                    catch (EKasaException e) {
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 20: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 2) {
            return 32;
        }
        try {
            this.esc = this.params[0];
            this.length = Integer.parseInt(this.params[1]);
            if (this.length < 0 || this.length > 999) {
                return 96;
            }
        }
        catch (NumberFormatException e) {
            return 96;
        }
        return 0;
    }

    @Override
    public void resetData() {
        this.atEnd = false;
    }

    @Override
    public byte[] getNextData() {
        byte[] data = this.dataOut;
        this.atEnd = true;
        return data;
    }

    @Override
    public boolean isAvailableData() {
        return !this.atEnd;
    }
}

