/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.Constant;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.interfaces.DataGetInterface;
import sk.singularisdev.ekasask.fm.util.Hex;

public class GetParagonIDs
extends FmCommand
implements DataGetInterface {
    private static final Logger logger = LoggerManager.getLogger((String)GetParagonIDs.class.getName());
    private int interfaceType;
    private String interfaceValue;
    private String dataOut;
    private boolean atEnd = true;

    public GetParagonIDs(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        if (fm.isDbOk()) {
            byte status = this.parseParams();
            if (status == 0) {
                try {
                    this.dataOut = fm.getParagonIDs(this.interfaceType, this.interfaceValue);
                }
                catch (FmStoreToDbException e) {
                    if (e.getMessage().equals("No data")) {
                        return 4;
                    }
                    return -2;
                }
                return status;
            }
            return status;
        }
        return -2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 2) {
            return 32;
        }
        try {
            this.interfaceType = Integer.parseInt(this.params[0]);
            if (this.interfaceType < 0) return 96;
            if (this.interfaceType > 4) {
                return 96;
            }
            switch (this.interfaceType) {
                case 0: {
                    this.interfaceValue = "";
                    return 0;
                }
                case 1: {
                    this.interfaceValue = this.params[1];
                    return 0;
                }
                case 2: {
                    this.interfaceValue = this.params[1];
                    if (this.interfaceValue.length() <= 50) return 0;
                    return 96;
                }
                case 3: {
                    this.interfaceValue = this.params[1];
                    if (this.interfaceValue.length() <= 34) return 0;
                    return 96;
                }
                case 4: {
                    this.interfaceValue = this.params[1];
                    if (this.interfaceValue.length() <= 11) return 0;
                    return 96;
                }
            }
            return 96;
        }
        catch (NumberFormatException e) {
            return 96;
        }
    }

    @Override
    public void resetData() {
        this.atEnd = false;
    }

    @Override
    public byte[] getNextData() {
        byte[] data = this.dataOut.getBytes(Constant.CHARSET);
        this.atEnd = true;
        return data;
    }

    @Override
    public boolean isAvailableData() {
        return !this.atEnd;
    }
}

