/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.math.BigDecimal;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.Checkers;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;

public class OdpocitanaZaloha
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)OdpocitanaZaloha.class.getName());
    private String description;
    private BigDecimal quantity;
    private BigDecimal totalPrice;
    private char vat;

    public OdpocitanaZaloha(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    fm.beginTransaction();
                    switch (fm.getParagon().getSaleType()) {
                        case faktura: {
                            fm.appendLocalInvoiceTurnover(this.totalPrice.negate());
                            break;
                        }
                        default: {
                            fm.getVat(this.vat).appendLocalTotal(this.totalPrice.negate());
                        }
                    }
                    fm.appendReceiptTotal(this.totalPrice.negate());
                    this.quantity = new BigDecimal("1.000");
                    fm.getParagon().addItem(new ItemModel.Builder().setDescription(this.description).setTotalPrice(this.totalPrice.toString()).setUnitPrice(this.totalPrice.toString()).setVat(this.vat).setQuantity(this.quantity.toString()).setItemType(ItemModel.ItemType.odpocitanaZaloha).build());
                    fm.getParagon().appendBinaryData(this.binary);
                    fm.saveDbParagon();
                    fm.setTransactionSuccesfull();
                    fm.endTransaction();
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            fm.endTransaction();
            logger.fatal("Database error", (Throwable)e);
            Function.initFMDB(fm);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block19: {
            FmFiscalMemory fm;
            block18: {
                block17: {
                    block16: {
                        block15: {
                            PPEKK ppekk;
                            block14: {
                                fm = this.eKasa.getFm();
                                ppekk = this.eKasa.getPPEKK();
                                switch (fm.getFmState()) {
                                    case 2: 
                                    case 32: {
                                        break;
                                    }
                                    default: {
                                        return 52;
                                    }
                                }
                                if (this.params.length != 4) {
                                    return 32;
                                }
                                this.description = this.params[0];
                                if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)false) <= fm.getCharCount()) break block14;
                                return 96;
                            }
                            if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)false) != 0) break block15;
                            return 33;
                        }
                        if (!Function.matches(this.description, ".*[\\x00-\\x19].*")) break block16;
                        return 96;
                    }
                    this.description.replaceAll("\\*", " ");
                    this.quantity = new BigDecimal(this.params[1]);
                    if (Checkers.get().checkValueFormat(this.params[1], 6, 2)) break block17;
                    return 33;
                }
                if (this.params[2].length() <= 1) break block18;
                return 33;
            }
            this.vat = this.params[2].charAt(0);
            if (fm.validateVat(this.vat)) break block19;
            return 96;
        }
        try {
            this.totalPrice = new BigDecimal(this.params[3]).abs();
            if (!Checkers.get().checkValueFormat(this.params[3], 6, 2)) {
                return 33;
            }
        }
        catch (NumberFormatException e) {
            return 96;
        }
        catch (Exception e) {
            return 96;
        }
        return 0;
    }
}

