/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.Correction;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.enums.SFSError;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.sfs.EKasaResponseException;

public class OpravaDokladu
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)OpravaDokladu.class.getName());
    private String correctionValue;

    public OpravaDokladu(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block7: {
            byte status;
            block8: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block7;
                    status = this.parseParams();
                    if (status != 0) break block8;
                    try {
                        ppekk.process((AbstractCommand)Correction.getInstance((String)this.correctionValue));
                        fm.setLastSFSError(0L);
                    }
                    catch (EKasaResponseException e) {
                        fm.setLastSFSError(e.getResponseCode());
                        fm.setLastPPEKKError(e.getErrorCode());
                        return SFSError.fromSFSCode(e.getResponseCode()).getInternalFmInternalCode();
                    }
                    catch (EKasaException e) {
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 1) {
            return 32;
        }
        this.correctionValue = this.params[0];
        if (!Formatter.get().isOSTimeZoneCorrect()) {
            return SFSError.SFS_ERROR_TIME_ZONE.getInternalFmInternalCode();
        }
        return 0;
    }
}

