/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.chdu.DisplayData;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.Display;
import sk.singularisdev.ekasask.enumeration.DISPLAY_NUMBER;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class PrintDisplay
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)PrintDisplay.class.getName());
    private int displayType;
    private String text;
    private String esc;

    public PrintDisplay(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    private byte[] shiftTextElcom(byte[] text) {
        int i = 0;
        while (i < text.length) {
            switch (text[i]) {
                case -13: {
                    text[i] = 25;
                    break;
                }
                case -6: {
                    text[i] = 40;
                    break;
                }
                case -19: {
                    text[i] = 41;
                    break;
                }
                case -3: {
                    text[i] = 42;
                    break;
                }
                case -12: {
                    text[i] = 43;
                    break;
                }
                case -99: {
                    text[i] = 44;
                    break;
                }
                case -31: {
                    text[i] = 45;
                    break;
                }
                case -102: {
                    text[i] = 46;
                    break;
                }
                case -98: {
                    text[i] = 47;
                    break;
                }
                case -24: {
                    text[i] = 52;
                    break;
                }
                case -17: {
                    text[i] = 53;
                    break;
                }
                case -14: {
                    text[i] = 56;
                    break;
                }
                case -66: {
                    text[i] = 82;
                    break;
                }
                case -55: 
                case -23: {
                    text[i] = -123;
                    break;
                }
                default: {
                    text[i] = (byte)(text[i] + -128);
                }
            }
            ++i;
        }
        return text;
    }

    private void initELCOM(DisplayData data, PPEKK ppekk) throws EKasaException {
        Display display = Display.getInstance((DISPLAY_NUMBER)(this.displayType == 0 ? DISPLAY_NUMBER.INTERNAL : DISPLAY_NUMBER.EXTERNAL));
        data.setData(new byte[]{85, 24, 77});
        display.addDisplayData(data);
        ppekk.process((AbstractCommand)display);
        display = Display.getInstance((DISPLAY_NUMBER)(this.displayType == 0 ? DISPLAY_NUMBER.INTERNAL : DISPLAY_NUMBER.EXTERNAL));
        byte[] byArray = new byte[19];
        byArray[0] = 85;
        byArray[1] = 33;
        byArray[2] = 118;
        byArray[3] = 13;
        byArray[4] = 15;
        byArray[6] = 52;
        byArray[7] = 8;
        byArray[8] = 6;
        byArray[9] = 53;
        byArray[10] = 2;
        byArray[11] = 4;
        byArray[12] = 8;
        byArray[13] = 16;
        byArray[14] = 64;
        byArray[15] = -64;
        byArray[16] = -128;
        byArray[17] = 52;
        byArray[18] = 37;
        data.setData(byArray);
        display.addDisplayData(data);
        ppekk.process((AbstractCommand)display);
        display = Display.getInstance((DISPLAY_NUMBER)(this.displayType == 0 ? DISPLAY_NUMBER.INTERNAL : DISPLAY_NUMBER.EXTERNAL));
        byte[] byArray2 = new byte[8];
        byArray2[0] = 85;
        byArray2[1] = 33;
        byArray2[2] = 118;
        byArray2[3] = 2;
        byArray2[6] = 12;
        byArray2[7] = 12;
        data.setData(byArray2);
        display.addDisplayData(data);
        ppekk.process((AbstractCommand)display);
        display = Display.getInstance((DISPLAY_NUMBER)(this.displayType == 0 ? DISPLAY_NUMBER.INTERNAL : DISPLAY_NUMBER.EXTERNAL));
        byte[] byArray3 = new byte[10];
        byArray3[0] = 85;
        byArray3[1] = 33;
        byArray3[2] = 118;
        byArray3[3] = 4;
        byArray3[4] = 6;
        byArray3[6] = 53;
        byArray3[7] = -98;
        byArray3[8] = 52;
        byArray3[9] = -97;
        data.setData(byArray3);
        display.addDisplayData(data);
        ppekk.process((AbstractCommand)display);
        display = Display.getInstance((DISPLAY_NUMBER)(this.displayType == 0 ? DISPLAY_NUMBER.INTERNAL : DISPLAY_NUMBER.EXTERNAL));
        data.setData(new byte[]{85, 25, 76});
        display.addDisplayData(data);
        ppekk.process((AbstractCommand)display);
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block15: {
            byte status;
            block16: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block15;
                    status = this.parseParams();
                    if (status != 0) break block16;
                    try {
                        DisplayData data = new DisplayData();
                        if (this.esc.equals("INIT_ELCOM")) {
                            this.initELCOM(data, ppekk);
                        }
                        switch (fm.getDisplayType()) {
                            case 2: {
                                Display display = Display.getInstance((DISPLAY_NUMBER)(this.displayType == 0 ? DISPLAY_NUMBER.INTERNAL : DISPLAY_NUMBER.EXTERNAL));
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                try {
                                    String[] parts = this.text.split("(?<=\\G...............)");
                                    if (parts.length >= 2) {
                                        baos.reset();
                                        baos.write(new byte[]{85, 33, 118, 19, 17, -128, -128, 64});
                                        baos.write(this.shiftTextElcom(parts[0].getBytes()));
                                        data.setData(baos.toByteArray());
                                        display.addDisplayData(data);
                                        ppekk.process((AbstractCommand)display);
                                        try {
                                            Thread.sleep(110L);
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                        baos.reset();
                                        baos.write(new byte[]{85, 33, 118, 19, 17, -128, -64, 64});
                                        baos.write(this.shiftTextElcom(parts[1].getBytes()));
                                        data.setData(baos.toByteArray());
                                        display.addDisplayData(data);
                                        ppekk.process((AbstractCommand)display);
                                        break;
                                    }
                                    baos.reset();
                                    baos.write(new byte[]{85, 33, 118, 19, 17, -128, -128, 64});
                                    baos.write(this.shiftTextElcom(parts[0].getBytes()));
                                    data.setData(baos.toByteArray());
                                    display.addDisplayData(data);
                                    ppekk.process((AbstractCommand)display);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                break;
                            }
                            default: {
                                Display display = Display.getInstance((DISPLAY_NUMBER)(this.displayType == 0 ? DISPLAY_NUMBER.INTERNAL : DISPLAY_NUMBER.EXTERNAL));
                                data.setData(Charset.forName("CP852").encode(this.text).array());
                                display.addDisplayData(data);
                                ppekk.process((AbstractCommand)display);
                                break;
                            }
                        }
                    }
                    catch (EKasaException e) {
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        block8: {
            FmFiscalMemory fm = this.eKasa.getFm();
            switch (fm.getFmState()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 10: 
                case 20: 
                case 32: 
                case 33: 
                case 34: {
                    break;
                }
                default: {
                    return 52;
                }
            }
            if (this.params.length != 3) {
                return 32;
            }
            try {
                this.displayType = Integer.parseInt(this.params[0]);
                if (this.displayType >= 0 && this.displayType <= 9) break block8;
                return 96;
            }
            catch (NumberFormatException e) {
                return 96;
            }
        }
        this.esc = this.params[1];
        this.text = this.params[2];
        if (this.text.length() > 40) {
            return 96;
        }
        return 0;
    }
}

