/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.InternalDocument;
import sk.singularisdev.ekasask.command.ItemPrint;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.command.internal.GetChduInfo;
import sk.singularisdev.ekasask.command.internal.GetIdentityInfo;
import sk.singularisdev.ekasask.command.internal.UnsendedTransaction;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.PaymentMethod;
import sk.singularisdev.ekasask.fm.data.Turnover;
import sk.singularisdev.ekasask.fm.enums.Align;
import sk.singularisdev.ekasask.fm.enums.ParagonType;
import sk.singularisdev.ekasask.fm.util.Hex;

public class PrintReport
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)PrintReport.class.getName());
    private char type;
    private int number;
    private int unsent = 0;
    private String chduSN = "";
    private String kp = "";

    public PrintReport(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block11: {
            byte status;
            block12: {
                try {
                    if (!fm.isDbOk()) break block11;
                    status = this.parseParams();
                    if (status != 0) break block12;
                    try {
                        UnsendedTransaction unsent = UnsendedTransaction.getInstance((boolean)false, (boolean)false);
                        ppekk.process((AbstractCommand)unsent);
                        GetChduInfo getChdu = GetChduInfo.getInstance();
                        ppekk.process((AbstractCommand)getChdu);
                        GetIdentityInfo getInfo = GetIdentityInfo.getInstance((boolean)false);
                        ppekk.process((AbstractCommand)getInfo);
                        this.unsent = unsent.getResponse().getUnsendedTransactionCount();
                        this.chduSN = getChdu.getResponse().getSn();
                        this.kp = getInfo.getResponse().getCashRegisterCode();
                        fm.beginTransaction();
                        Date date = new Date();
                        switch (this.type) {
                            case 'X': {
                                if (this.number > 0 && this.number < 5) {
                                    ppekk.process((AbstractCommand)(fm.getCharCount() <= 32 ? this.generateReport32(date, fm, false, this.number == 1) : this.generateReport(date, fm, false, this.number == 1)));
                                }
                                if (this.number != 5) break;
                                ppekk.process((AbstractCommand)this.generateServiceReport(date, fm));
                                break;
                            }
                            case 'Z': {
                                InternalDocument command = fm.getCharCount() <= 32 ? this.generateReport32(date, fm, true, this.number == 1) : this.generateReport(date, fm, true, this.number == 1);
                                fm.setLastReportDate(date);
                                fm.createJournalReport(date, this.binary, command.getUUID(), ParagonType.uzavierka);
                                if (this.number > 0 && this.number < 5) {
                                    ppekk.process((AbstractCommand)command);
                                }
                                fm.confirmJournal(command.getUUID());
                            }
                        }
                        fm.setTransactionSuccesfull();
                        fm.endTransaction();
                    }
                    catch (EKasaException e) {
                        fm.endTransaction();
                        Function.initFMDB(fm);
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    fm.endTransaction();
                    Function.initFMDB(fm);
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    private InternalDocument generateReport32(Date date, FmFiscalMemory fm, boolean deleteCounters, boolean zeroValues) throws EKasaException {
        String row = " ";
        int maxChars = fm.getCharCount();
        InternalDocument report = InternalDocument.getInstance();
        String[] stringArray = fm.getHeader();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String headerRow = stringArray[n2];
            if (!headerRow.equals("")) {
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)headerRow));
            }
            ++n2;
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().repeat('*', maxChars)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().align("Preh\u013eadov\u00e1 uz\u00e1vierka *" + (deleteCounters ? "Z" : "X") + this.number + "*", maxChars, Align.center)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().align("Denn\u00e1", maxChars, Align.center)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().repeat('*', maxChars)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        if (deleteCounters) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("DENN\u00c1 SPR\u00c1VA:%" + (maxChars - 13) + "s", fm.getReportNumber())));
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("GT:%" + (maxChars - 3) + "s", fm.getGT().setScale(2, RoundingMode.UNNECESSARY))));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        BigDecimal turnoverTotal = BigDecimal.ZERO;
        char ch = 'A';
        while (ch < 'F') {
            if (fm.getVat(ch).getVat() != null) {
                if (fm.getVat(ch).getGlobalTotal().compareTo(BigDecimal.ZERO) != 0 || !zeroValues) {
                    report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("OBRAT %s%7s%%%" + (maxChars - 15) + "s", Character.valueOf(ch), fm.getVat(ch).getVat(), fm.getVat(ch).getGlobalTotal())));
                }
                turnoverTotal = turnoverTotal.add(fm.getVat(ch).getGlobalTotal());
            }
            ch = (char)(ch + '\u0001');
        }
        if (fm.getInvoiceTurnover().compareTo(BigDecimal.ZERO) != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("\u00daHRADA POH\u013d.   :PO\u010c:%05d", fm.getinvoiceCounter())));
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%" + maxChars + "s", fm.getInvoiceTurnover())));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("OBRAT CELKOM%" + (maxChars - 12) + "s", turnoverTotal)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)" "));
        turnoverTotal = BigDecimal.ZERO;
        ch = 'A';
        while (ch < 'F') {
            if (fm.getVat(ch).getVat() != null) {
                if (fm.getVat(ch).getGlobalBase().compareTo(BigDecimal.ZERO) != 0 || !zeroValues) {
                    report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("ZDA\u0147 %s%7s%%%" + (maxChars - 14) + "s", Character.valueOf(ch), fm.getVat(ch).getVat(), fm.getVat(ch).getGlobalBase())));
                }
                turnoverTotal = turnoverTotal.add(fm.getVat(ch).getGlobalBase());
            }
            ch = (char)(ch + '\u0001');
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("ZDA\u0147 CELKOM%" + (maxChars - 11) + "s", turnoverTotal)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        turnoverTotal = BigDecimal.ZERO;
        ch = 'A';
        while (ch < 'F') {
            if (fm.getVat(ch).getVat() != null) {
                if (fm.getVat(ch).getGlobalVat().compareTo(BigDecimal.ZERO) != 0 || !zeroValues) {
                    report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("DA\u0147 %s%7s%%%" + (maxChars - 13) + "s", Character.valueOf(ch), fm.getVat(ch).getVat(), fm.getVat(ch).getGlobalVat())));
                }
                turnoverTotal = turnoverTotal.add(fm.getVat(ch).getGlobalVat());
            }
            ch = (char)(ch + '\u0001');
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("DA\u0147 CELKOM%" + (maxChars - 10) + "s", turnoverTotal)));
        if (fm.getInvalidReceiptCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"NEPLATN\u00dd DOKLAD:"));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" PO\u010c:%05d%" + (maxChars - 10) + "s", fm.getInvalidReceiptCount(), fm.getInvalidReceiptTotal())));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        }
        if (fm.getNegativeGlobalCounter().getVoidCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"STORNO POLO\u017dKY :"));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" PO\u010c:%05d%" + (maxChars - 10) + "s", fm.getNegativeGlobalCounter().getVoidCount(), fm.getNegativeGlobalCounter().getVoidValue())));
        }
        if (fm.getNegativeGlobalCounter().getReturnCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"VR\u00c1T. POLO\u017dKY  :"));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" PO\u010c:%05d%" + (maxChars - 10) + "s", fm.getNegativeGlobalCounter().getReturnCount(), fm.getNegativeGlobalCounter().getReturnValue())));
        }
        if (fm.getGlobalDiscountTotalCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"Z\u013dAVA CELKOM   :"));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" PO\u010c:%05d%" + (maxChars - 10) + "s", fm.getGlobalDiscountTotalCount(), fm.getGlobalDiscountTotal())));
        }
        if (fm.getNegativeGlobalCounter().getNegativeCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"Z\u00c1PORN\u00c9 POLO\u017dKY:"));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" PO\u010c:%05d%" + (maxChars - 10) + "s", fm.getNegativeGlobalCounter().getNegativeCount(), fm.getNegativeGlobalCounter().getNegativeValue())));
        }
        if (fm.getNegativeGlobalCounter().getAllNegativeCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"Z\u00c1PORN\u00dd OBRAT  :"));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" PO\u010c:%05d%" + (maxChars - 10) + "s", fm.getNegativeGlobalCounter().getAllNegativeCount(), fm.getNegativeGlobalCounter().getAllNegativeTotal())));
        }
        if (fm.getNegativeGlobalCounter().getDestroyedCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"ZRU\u0160EN\u00c9 PREDAJE:"));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" PO\u010c:%05d%" + (maxChars - 10) + "s", fm.getNegativeGlobalCounter().getDestroyedCount(), fm.getNegativeGlobalCounter().getDestroyedValue())));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"S\u00daPIS PLATIDIEL:"));
        int vkladCLK = 0;
        int vyberCLK = 0;
        for (Map.Entry<Integer, PaymentMethod> payment : fm.getPaymentMethods().entrySet()) {
            if (payment.getValue().getPaymentCount() != 0 || !zeroValues) {
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%02d %-10s :%04d", payment.getKey(), payment.getValue().getName(), payment.getValue().getPaymentCount())));
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" %11s%" + (maxChars - 12) + "s", payment.getValue().getGlobalTurnover(), payment.getValue().getExchangeGlobalTurnover())));
            }
            if (payment.getValue().getDepositeCount() != 0 || !zeroValues) {
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%02d VKLAD      :%04d", payment.getKey(), payment.getValue().getDepositeCount())));
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" %11s", payment.getValue().getGlobalDeposite())));
            }
            if (payment.getValue().getWithdrawCount() != 0 || !zeroValues) {
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%02d V\u00ddBER      :%04d", payment.getKey(), payment.getValue().getWithdrawCount())));
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" %11s", payment.getValue().getGlobalWithdraw())));
            }
            if (payment.getValue().getGlobalTurnover().add(payment.getValue().getGlobalDeposite()).add(payment.getValue().getGlobalWithdraw().negate()).compareTo(BigDecimal.ZERO) != 0 && zeroValues) {
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%02d ZOSTATOK", payment.getKey())));
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" %11s", payment.getValue().getGlobalTurnover().add(payment.getValue().getGlobalDeposite()).add(payment.getValue().getGlobalWithdraw().negate()))));
            }
            vkladCLK += payment.getValue().getDepositeCount();
            vyberCLK += payment.getValue().getWithdrawCount();
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"VKLAD CELKOM    :"));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" PO\u010c:%04d", vkladCLK)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"V\u00ddBER CELKOM"));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" PO\u010c:%04d", vyberCLK)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"VKLAD/V\u00ddBER CLK.:"));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format(" PO\u010c:%04d", fm.getDespositeWithdrawCount())));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)" "));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("EKASA NEODOSLAN\u00c9:%" + (maxChars - 17) + "s", this.unsent)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("SN CHD\u00da:%" + (maxChars - 8) + "s", this.chduSN)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("K\u00d3D POKLADNE:%" + (maxChars - 13) + "s", this.kp)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().repeat('*', maxChars)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().align(Formatter.get().generateStringDate("dd/MM/yyyy kk:mm", date), maxChars, Align.center)));
        return report;
    }

    private InternalDocument generateReport(Date date, FmFiscalMemory fm, boolean deleteCounters, boolean zeroValues) throws EKasaException {
        String row = " ";
        int maxChars = fm.getCharCount();
        InternalDocument report = InternalDocument.getInstance();
        String[] stringArray = fm.getHeader();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String headerRow = stringArray[n2];
            if (!headerRow.equals("")) {
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)headerRow));
            }
            ++n2;
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().repeat('*', maxChars)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().align("Preh\u013eadov\u00e1 uz\u00e1vierka *" + (deleteCounters ? "Z" : "X") + this.number + "*", maxChars, Align.center)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().align("Denn\u00e1", maxChars, Align.center)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().repeat('*', maxChars)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        if (deleteCounters) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("\u010c\u00cdSLO DENNEJ SPR\u00c1VY:%" + (maxChars - 20) + "s", fm.getReportNumber())));
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("KUMULOVAN\u00dd OBRAT:%" + (maxChars - 17) + "s", fm.getGT().setScale(2, RoundingMode.UNNECESSARY))));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        BigDecimal turnoverTotal = BigDecimal.ZERO;
        char ch = 'A';
        while (ch < 'F') {
            if (fm.getVat(ch).getVat() != null) {
                if (fm.getVat(ch).getGlobalTotal().compareTo(BigDecimal.ZERO) != 0 || !zeroValues) {
                    report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("OBRAT %s%7s%%%" + (maxChars - 15) + "s", Character.valueOf(ch), fm.getVat(ch).getVat(), fm.getVat(ch).getGlobalTotal())));
                }
                turnoverTotal = turnoverTotal.add(fm.getVat(ch).getGlobalTotal());
            }
            ch = (char)(ch + '\u0001');
        }
        if (fm.getInvoiceTurnover().compareTo(BigDecimal.ZERO) != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("\u00daHRADA POH\u013d.   :PO\u010c:%05d%" + (maxChars - 25) + "s", fm.getinvoiceCounter(), fm.getInvoiceTurnover())));
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("OBRAT CELKOM%" + (maxChars - 12) + "s", turnoverTotal)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)" "));
        turnoverTotal = BigDecimal.ZERO;
        ch = 'A';
        while (ch < 'F') {
            if (fm.getVat(ch).getVat() != null) {
                if (fm.getVat(ch).getGlobalBase().compareTo(BigDecimal.ZERO) != 0 || !zeroValues) {
                    report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("ZDA\u0147 %s%7s%%%" + (maxChars - 14) + "s", Character.valueOf(ch), fm.getVat(ch).getVat(), fm.getVat(ch).getGlobalBase())));
                }
                turnoverTotal = turnoverTotal.add(fm.getVat(ch).getGlobalBase());
            }
            ch = (char)(ch + '\u0001');
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("ZDA\u0147 CELKOM%" + (maxChars - 11) + "s", turnoverTotal)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        turnoverTotal = BigDecimal.ZERO;
        ch = 'A';
        while (ch < 'F') {
            if (fm.getVat(ch).getVat() != null) {
                if (fm.getVat(ch).getGlobalVat().compareTo(BigDecimal.ZERO) != 0 || !zeroValues) {
                    report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("DA\u0147 %s%7s%%%" + (maxChars - 13) + "s", Character.valueOf(ch), fm.getVat(ch).getVat(), fm.getVat(ch).getGlobalVat())));
                }
                turnoverTotal = turnoverTotal.add(fm.getVat(ch).getGlobalVat());
            }
            ch = (char)(ch + '\u0001');
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("DA\u0147 CELKOM%" + (maxChars - 10) + "s", turnoverTotal)));
        if (fm.getInvalidReceiptCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("NEPLATN\u00dd DOKLAD: PO\u010c:%05d%" + (maxChars - 26) + "s", fm.getInvalidReceiptCount(), fm.getInvalidReceiptTotal())));
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        if (fm.getNegativeGlobalCounter().getVoidCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("STORNO POLO\u017dKY : PO\u010c:%05d%" + (maxChars - 26) + "s", fm.getNegativeGlobalCounter().getVoidCount(), fm.getNegativeGlobalCounter().getVoidValue())));
        }
        if (fm.getNegativeGlobalCounter().getReturnCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("VR\u00c1T. POLO\u017dKY  : PO\u010c:%05d%" + (maxChars - 26) + "s", fm.getNegativeGlobalCounter().getReturnCount(), fm.getNegativeGlobalCounter().getReturnValue())));
        }
        if (fm.getGlobalDiscountTotalCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("Z\u013dAVA CELKOM   : PO\u010c:%05d%" + (maxChars - 26) + "s", fm.getGlobalDiscountTotalCount(), fm.getGlobalDiscountTotal())));
        }
        if (fm.getNegativeGlobalCounter().getNegativeCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("Z\u00c1PORN\u00c9 POLO\u017dKY: PO\u010c:%05d%" + (maxChars - 26) + "s", fm.getNegativeGlobalCounter().getNegativeCount(), fm.getNegativeGlobalCounter().getNegativeValue())));
        }
        if (fm.getNegativeGlobalCounter().getAllNegativeCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("Z\u00c1PORN\u00dd OBRAT  : PO\u010c:%05d%" + (maxChars - 26) + "s", fm.getNegativeGlobalCounter().getAllNegativeCount(), fm.getNegativeGlobalCounter().getAllNegativeTotal())));
        }
        if (fm.getNegativeGlobalCounter().getDestroyedCount() != 0 || !zeroValues) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("ZRU\u0160EN\u00c9 PREDAJE: PO\u010c:%05d%" + (maxChars - 26) + "s", fm.getNegativeGlobalCounter().getDestroyedCount(), fm.getNegativeGlobalCounter().getDestroyedValue())));
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"S\u00daPIS PLATIDIEL:"));
        int vkladCLK = 0;
        int vyberCLK = 0;
        for (Map.Entry<Integer, PaymentMethod> payment : fm.getPaymentMethods().entrySet()) {
            if (payment.getValue().getPaymentCount() != 0 || !zeroValues) {
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%02d %-10s :%04d%11s%" + (maxChars - 30) + "s", payment.getKey(), payment.getValue().getName(), payment.getValue().getPaymentCount(), payment.getValue().getGlobalTurnover(), payment.getValue().getExchangeGlobalTurnover())));
            }
            if (payment.getValue().getDepositeCount() != 0 || !zeroValues) {
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%02d VKLAD      :%04d%11s", payment.getKey(), payment.getValue().getDepositeCount(), payment.getValue().getGlobalDeposite())));
            }
            if (payment.getValue().getWithdrawCount() != 0 || !zeroValues) {
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%02d V\u00ddBER      :%04d%11s", payment.getKey(), payment.getValue().getWithdrawCount(), payment.getValue().getGlobalWithdraw())));
            }
            if (payment.getValue().getGlobalTurnover().add(payment.getValue().getGlobalDeposite()).add(payment.getValue().getGlobalWithdraw().negate()).compareTo(BigDecimal.ZERO) != 0 && zeroValues) {
                report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%02d ZOSTATOK%19s", payment.getKey(), payment.getValue().getGlobalTurnover().add(payment.getValue().getGlobalDeposite()).add(payment.getValue().getGlobalWithdraw().negate()))));
            }
            vkladCLK += payment.getValue().getDepositeCount();
            vyberCLK += payment.getValue().getWithdrawCount();
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("VKLAD CELKOM    :PO\u010c:%04d", vkladCLK)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("V\u00ddBER CELKOM    :PO\u010c:%04d", vyberCLK)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("VKLAD/V\u00ddBER CLK.:PO\u010c:%04d", fm.getDespositeWithdrawCount())));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)" "));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("EKASA NEODOSLAN\u00c9:%" + (maxChars - 17) + "s", this.unsent)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("SN CHD\u00da:%" + (maxChars - 8) + "s", this.chduSN)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("K\u00d3D POKLADNE:%" + (maxChars - 13) + "s", this.kp)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().repeat('*', maxChars)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().align(Formatter.get().generateStringDate("dd/MM/yyyy kk:mm", date), maxChars, Align.center)));
        return report;
    }

    private InternalDocument generateServiceReport(Date date, FmFiscalMemory fm) throws EKasaException {
        String r;
        int maxChars = fm.getCharCount();
        String row = " ";
        InternalDocument report = InternalDocument.getInstance();
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().repeat('*', maxChars)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().align("Servisn\u00e1 spr\u00e1va", maxChars, Align.center)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().align("X5", maxChars, Align.center)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().repeat('*', maxChars)));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"Pr\u00eddavn\u00e1 hlavi\u010dka:"));
        String[] stringArray = Formatter.get().Split(fm.getAdditionalHeader(), maxChars);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            r = stringArray[n2];
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)r));
            ++n2;
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"Pr\u00eddavn\u00e1 p\u00e4ti\u010dka:"));
        stringArray = Formatter.get().Split(fm.getAdditionalFooter(), maxChars);
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            r = stringArray[n2];
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)r));
            ++n2;
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)row));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"DIAKRITIKA:"));
        stringArray = Formatter.get().Split("a\u00e1\u00e4bc\u010dd\u010fe\u00e9fghi\u00edjkl\u013a\u013emn\u0148o\u00f3\u00f4pqr\u0155s\u0161t\u0165u\u00favwxy\u00fdz\u017aA\u00c1\u00c4BC\u010cD\u010eE\u00c9FGHI\u00cdJKL\u0139\u013dMN\u0147O\u00d3\u00d4PQR\u0154S\u0160T\u0164U\u00daVWXY\u00ddZ\u017d", maxChars);
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            r = stringArray[n2];
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)r));
            ++n2;
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("Z1:%05d", fm.getReportNumber())));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("KUMULOVAN\u00dd OBRAT:%" + (maxChars - 17) + "s", fm.getGT())));
        StringBuilder dane = new StringBuilder();
        for (Map.Entry<Character, Turnover> dan : fm.getVats().entrySet()) {
            dane.append(String.format("D%s:%d|%s  ", dan.getKey(), dan.getValue().getVat(), dan.getValue().getVatType()));
        }
        String[] stringArray2 = Formatter.get().Split(dane.toString(), maxChars);
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String r2 = stringArray2[n4];
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)r2));
            ++n4;
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"Stav platidiel:"));
        for (Map.Entry<Integer, PaymentMethod> platidlo : fm.getPaymentMethods().entrySet()) {
            report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%s%" + (maxChars - platidlo.getValue().getName().length() - 7) + "s,%s,%s", platidlo.getValue().getName(), platidlo.getKey(), platidlo.getValue().getMinCurrency(), platidlo.getValue().isOverpay() ? "0" : "1")));
        }
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("\u010c\u00cdSLO \u00da\u010cTENKY:%05d", fm.getReceiptNumber())));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)"Verzia SW: 115 Build: 15"));
        report.addItem((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().align(Formatter.get().generateStringDate("dd/MM/yyyy kk:mm", date), maxChars, Align.center)));
        return report;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        if (this.params.length != 2) {
            return 32;
        }
        try {
            this.type = this.params[0].charAt(0);
            if (this.type != 'X' && this.type != 'Z') {
                return 96;
            }
            switch (this.type) {
                case 'X': {
                    this.number = Integer.parseInt(this.params[1]);
                    if (this.number < 1) return 96;
                    if (this.number <= 5) break;
                    return 96;
                }
                case 'Z': {
                    this.number = Integer.parseInt(this.params[1]);
                    if (this.number < 1) return 96;
                    if (this.number <= 5) break;
                    return 96;
                }
            }
            switch (fm.getFmState()) {
                case 0: {
                    if (this.type == 'X') return 0;
                    if (this.number == 5) return 0;
                    return 96;
                }
                case 1: {
                    return 0;
                }
            }
            return 52;
        }
        catch (NumberFormatException e) {
            return 96;
        }
    }
}

