/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.setup.Setup;
import sk.singularisdev.ekasask.command.setup.SetupItemAuthenticationData;
import sk.singularisdev.ekasask.command.setup.SetupItemAuthenticationPassword;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetAutKey
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetAutKey.class.getName());
    private String filePath;
    private String password;

    public SetAutKey(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (!fm.isDbOk()) return -2;
            byte status = this.parseParams();
            if (status != 0) return status;
            try {
                Setup setup = Setup.getInstance();
                SetupItemAuthenticationData setupItemAuth = SetupItemAuthenticationData.getInstance();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filePath), "UTF8"));
                String line = null;
                StringBuilder stringBuilder = new StringBuilder();
                String ls = System.getProperty("line.separator");
                try {
                    while ((line = reader.readLine()) != null) {
                        stringBuilder.append(line);
                        stringBuilder.append(ls);
                    }
                }
                finally {
                    reader.close();
                }
                setupItemAuth.setAuthenticationData(stringBuilder.toString());
                setup.addItem((SetupItemInterface)setupItemAuth);
                SetupItemAuthenticationPassword setupItemPassword = SetupItemAuthenticationPassword.getInstance();
                setupItemPassword.setPassword(this.password);
                setup.addItem((SetupItemInterface)setupItemPassword);
                ppekk.process((AbstractCommand)setup);
                return status;
            }
            catch (EKasaException e) {
                fm.setLastPPEKKError(e.getErrorCode());
                return -3;
            }
            catch (UnsupportedEncodingException e) {
                return -47;
            }
            catch (FileNotFoundException e) {
                return -48;
            }
            catch (IOException e) {
                return -47;
            }
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 2) {
            return 32;
        }
        try {
            this.password = this.params[0];
            this.filePath = this.params[1];
            if (this.filePath.length() > 255) {
                return 96;
            }
        }
        catch (NumberFormatException e) {
            return 96;
        }
        return 0;
    }
}

