/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.enumeration.CUSTOMER_TYPE;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.Customer;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetClientID
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetClientID.class.getName());
    private String customerIndetification;
    private int typeOfData;

    public SetClientID(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    if (fm.getParagon().getCustomer() == null) {
                        fm.getParagon().setCustomer(new Customer(this.getType(this.typeOfData), this.customerIndetification));
                    } else {
                        fm.getParagon().setCustomer(this.getType(this.typeOfData), this.customerIndetification);
                    }
                    fm.getParagon().appendBinaryData(this.binary);
                    fm.saveDbParagon();
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    private CUSTOMER_TYPE getType(int value) {
        switch (value) {
            case 1: {
                return CUSTOMER_TYPE.ICO;
            }
            case 2: {
                return CUSTOMER_TYPE.DIC;
            }
            case 3: {
                return CUSTOMER_TYPE.IC_DPH;
            }
            case 4: {
                return CUSTOMER_TYPE.INE;
            }
        }
        return CUSTOMER_TYPE.ICO;
    }

    @Override
    protected byte parseParams() {
        block11: {
            block10: {
                block9: {
                    FmFiscalMemory fm = this.eKasa.getFm();
                    switch (fm.getFmState()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 32: 
                        case 33: 
                        case 34: {
                            break;
                        }
                        default: {
                            return 52;
                        }
                    }
                    try {
                        if (this.params.length == 2) break block9;
                        return 32;
                    }
                    catch (NumberFormatException e) {
                        return 96;
                    }
                }
                this.customerIndetification = this.params[0];
                if (this.customerIndetification.length() != 0 && this.customerIndetification.length() <= 50) break block10;
                return 96;
            }
            if (!Function.matches(this.customerIndetification, "^[a-zA-Z0-9]*$")) break block11;
            return 96;
        }
        this.typeOfData = Integer.parseInt(this.params[1]);
        if (this.typeOfData < 1 || this.typeOfData > 4) {
            return 96;
        }
        return 0;
    }
}

