/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.setup.Setup;
import sk.singularisdev.ekasask.command.setup.SetupItemDisplay;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.enumeration.DISPLAY_CONNECTION_TYPE;
import sk.singularisdev.ekasask.enumeration.DISPLAY_NUMBER;
import sk.singularisdev.ekasask.enumeration.DISPLAY_TYPE;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetDispF
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetDispF.class.getName());
    private String password;
    private DISPLAY_NUMBER displayID;
    private DISPLAY_CONNECTION_TYPE connectionType;
    private DISPLAY_TYPE displayType;
    private Integer rate;

    public SetDispF(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block7: {
            byte status;
            block8: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block7;
                    status = this.parseParams();
                    if (status != 0) break block8;
                    try {
                        Setup setup = Setup.getInstance();
                        SetupItemDisplay display = SetupItemDisplay.getInstance((DISPLAY_NUMBER)this.displayID);
                        display.setConnectionType(this.connectionType);
                        display.setDisplayType(this.displayType);
                        if (this.rate != null) {
                            display.setConnectionSetting(this.rate.toString());
                        }
                        setup.addItem((SetupItemInterface)display);
                        ppekk.process((AbstractCommand)setup);
                        fm.setDisplayType(Integer.parseInt(this.params[1]));
                    }
                    catch (EKasaException e) {
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        int dispConnectionType;
        block24: {
            int dispID;
            block23: {
                block22: {
                    block21: {
                        FmFiscalMemory fm = this.eKasa.getFm();
                        switch (fm.getFmState()) {
                            case 0: 
                            case 1: {
                                break;
                            }
                            default: {
                                return 52;
                            }
                        }
                        if (this.params.length != 4) {
                            return 32;
                        }
                        try {
                            this.password = this.params[0];
                            if (Formatter.get().getMD5Format(this.password).equals(fm.getPassword())) break block21;
                            return 49;
                        }
                        catch (NumberFormatException e) {
                            return 96;
                        }
                    }
                    if (this.password.length() >= 6 && this.password.length() <= 8) break block22;
                    return 96;
                }
                dispID = Integer.parseInt(this.params[1]);
                if (dispID >= 0 && dispID <= 2) break block23;
                return 96;
            }
            switch (dispID) {
                case 0: {
                    this.displayID = DISPLAY_NUMBER.INTERNAL;
                    break;
                }
                case 1: 
                case 2: {
                    this.displayID = DISPLAY_NUMBER.EXTERNAL;
                }
            }
            dispConnectionType = Integer.parseInt(this.params[2]);
            if (dispConnectionType >= 0 && dispConnectionType <= 2) break block24;
            return 96;
        }
        switch (dispConnectionType) {
            case 0: {
                this.connectionType = DISPLAY_CONNECTION_TYPE.SERIAL;
                this.displayType = DISPLAY_TYPE.BOWA_STANDARD;
                break;
            }
            case 1: {
                this.connectionType = DISPLAY_CONNECTION_TYPE.SPI;
                this.displayType = DISPLAY_TYPE.BOWA_STANDARD;
                break;
            }
            case 2: {
                this.connectionType = DISPLAY_CONNECTION_TYPE.PARALLEL;
                this.displayType = DISPLAY_TYPE.BOWA_STANDARD;
                break;
            }
            default: {
                return 96;
            }
        }
        if (this.params[3] == null || this.params[3].equals("")) {
            this.rate = null;
        }
        this.rate = Integer.parseInt(this.params[3]);
        return 0;
    }
}

