/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.InternalDocument;
import sk.singularisdev.ekasask.command.ItemPrintBinary;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetEscapeSequence
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetEscapeSequence.class.getName());
    private String esc;

    public SetEscapeSequence(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (!fm.isDbOk()) return -2;
            byte status = this.parseParams();
            if (status != 0) return status;
            switch (fm.getFmState()) {
                case 2: 
                case 3: 
                case 10: 
                case 20: 
                case 32: 
                case 33: {
                    fm.getParagon().addItem(new ItemModel.Builder().setRow(-1).setDescription(this.esc).setItemType(ItemModel.ItemType.printAnnouncement).build());
                    fm.saveDbParagon();
                    return status;
                }
                case 4: 
                case 34: {
                    fm.getParagon().addFinalItem(new ItemModel.Builder().setRow(-1).setDescription(this.esc).setItemType(ItemModel.ItemType.printAnnouncement).build());
                    fm.saveDbParagon();
                    return status;
                }
                case 0: 
                case 1: {
                    try {
                        InternalDocument document = InternalDocument.getInstance();
                        document.setAutoCutter(false);
                        document.addItem((MessageItemInterfaceParagon)ItemPrintBinary.getInstance((byte[])ppekk.getPrinter().rewriteEscSequence(this.esc, false, true).getBytes(ppekk.getPrinter().getCharset())));
                        ppekk.process((AbstractCommand)document);
                        return status;
                    }
                    catch (EKasaException e) {
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
            }
            return status;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 20: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 1) {
            return 32;
        }
        try {
            this.esc = this.params[0];
        }
        catch (NumberFormatException e) {
            return 96;
        }
        return 0;
    }
}

