/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;

public class SetHeader
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetHeader.class.getName());
    private String password;
    private int row;
    private String text;

    public SetHeader(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    String[] header = fm.getHeader();
                    header[this.row - 1] = this.text;
                    fm.setHeader(header);
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        PPEKK ppekk;
        FmFiscalMemory fm;
        block12: {
            block11: {
                block10: {
                    fm = this.eKasa.getFm();
                    ppekk = this.eKasa.getPPEKK();
                    switch (fm.getFmState()) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            return 52;
                        }
                    }
                    if (this.params.length != 3) {
                        return 32;
                    }
                    try {
                        this.password = this.params[0];
                        if (Formatter.get().getMD5Format(this.password).equals(fm.getPassword())) break block10;
                        return 49;
                    }
                    catch (NumberFormatException e) {
                        return 96;
                    }
                }
                if (this.password.length() >= 6 && this.password.length() <= 8) break block11;
                return 96;
            }
            this.row = Integer.parseInt(this.params[1]);
            if (this.row >= 1 && this.row <= 6) break block12;
            return 96;
        }
        this.text = this.params[2];
        if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.text, (boolean)false) > fm.getCharCount()) {
            return 33;
        }
        return 0;
    }
}

