/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetInvoiceNumber
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetInvoiceNumber.class.getName());
    private String invoiceNumber;

    public SetInvoiceNumber(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    fm.getParagon().setInvoiceNumber(this.invoiceNumber);
                    fm.getParagon().appendBinaryData(this.binary);
                    fm.saveDbParagon();
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 1) {
            return 32;
        }
        this.invoiceNumber = this.params[0];
        if (this.invoiceNumber.length() < 1 || this.invoiceNumber.length() > 50) {
            return 96;
        }
        if (Function.matches(this.invoiceNumber, ".*[\\x00-\\x19].*")) {
            return 96;
        }
        return 0;
    }
}

