/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetParameter
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetParameter.class.getName());
    private String password;
    private int paramId;
    private int paramValue;

    public SetParameter(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    switch (this.paramId) {
                        case 0: {
                            fm.setVatPayer(this.paramValue == 0);
                            break;
                        }
                        case 6: {
                            fm.setSafeMode(this.paramValue == 1);
                            break;
                        }
                        case 7: {
                            fm.setDepositeOverhaul(this.paramValue == 1);
                        }
                    }
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block12: {
            block11: {
                block10: {
                    FmFiscalMemory fm = this.eKasa.getFm();
                    switch (fm.getFmState()) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            return 52;
                        }
                    }
                    if (this.params.length != 3) {
                        return 32;
                    }
                    try {
                        this.password = this.params[0];
                        if (Formatter.get().getMD5Format(this.password).equals(fm.getPassword())) break block10;
                        return 49;
                    }
                    catch (NumberFormatException e) {
                        return 96;
                    }
                }
                if (this.password.length() >= 6 && this.password.length() <= 8) break block11;
                return 96;
            }
            this.paramId = Integer.parseInt(this.params[1]);
            if (this.paramId >= 0 && this.paramId <= 7) break block12;
            return 96;
        }
        this.paramValue = Integer.parseInt(this.params[2]);
        if (this.paramValue < 0 || this.paramValue > 1) {
            return 96;
        }
        return 0;
    }
}

