/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.setup.Setup;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.command.setup.SetupItemPrinterBaudrate;
import sk.singularisdev.ekasask.command.setup.SetupItemPrinterType;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.enums.Baudrate;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.driver.BL112N;
import sk.singularisdev.ekasask.printer.driver.Gimex;
import sk.singularisdev.ekasask.printer.driver.MarkEETa;
import sk.singularisdev.ekasask.printer.driver.Modulino;
import sk.singularisdev.ekasask.printer.driver.Modulino32;
import sk.singularisdev.ekasask.printer.driver.PCPOS1_57;
import sk.singularisdev.ekasask.printer.driver.PCPOS1_80;
import sk.singularisdev.ekasask.printer.driver.PegasinoFTN;
import sk.singularisdev.ekasask.printer.driver.RONGTA80;
import sk.singularisdev.ekasask.printer.driver.SPPR310;
import sk.singularisdev.ekasask.printer.driver.SPPR410;
import sk.singularisdev.ekasask.printer.driver.SRP350IIN;
import sk.singularisdev.ekasask.printer.driver.SRP350N;
import sk.singularisdev.ekasask.printer.driver.SRPN350;
import sk.singularisdev.ekasask.printer.driver.SRPN350II;
import sk.singularisdev.ekasask.printer.driver.Sam4S;
import sk.singularisdev.ekasask.printer.driver.SunmiN;
import sk.singularisdev.ekasask.printer.driver.TMH6000;
import sk.singularisdev.ekasask.printer.driver.TMT20IIA;
import sk.singularisdev.ekasask.printer.driver.TMT20IIB;
import sk.singularisdev.ekasask.printer.driver.TMT88III;
import sk.singularisdev.ekasask.printer.driver.TMT88V;
import sk.singularisdev.ekasask.printer.driver.Universal218012B;
import sk.singularisdev.ekasask.printer.driver.Universal218012BO;
import sk.singularisdev.ekasask.printer.driver.Universal218012BQ;
import sk.singularisdev.ekasask.printer.driver.Universal218012BQO;
import sk.singularisdev.ekasask.printer.driver.Universal220312B;
import sk.singularisdev.ekasask.printer.driver.Universal220312BO;
import sk.singularisdev.ekasask.printer.driver.Universal220312BQ;
import sk.singularisdev.ekasask.printer.driver.Universal220312BQO;
import sk.singularisdev.ekasask.printer.driver.Universal318012A;
import sk.singularisdev.ekasask.printer.driver.Universal318012AO;
import sk.singularisdev.ekasask.printer.driver.Universal318012AQ;
import sk.singularisdev.ekasask.printer.driver.Universal318012AQO;
import sk.singularisdev.ekasask.printer.driver.Universal318012B;
import sk.singularisdev.ekasask.printer.driver.Universal318012BO;
import sk.singularisdev.ekasask.printer.driver.Universal318012BQ;
import sk.singularisdev.ekasask.printer.driver.Universal318012BQO;
import sk.singularisdev.ekasask.printer.driver.Universal320312A;
import sk.singularisdev.ekasask.printer.driver.Universal320312AO;
import sk.singularisdev.ekasask.printer.driver.Universal320312AQ;
import sk.singularisdev.ekasask.printer.driver.Universal320312AQO;
import sk.singularisdev.ekasask.printer.driver.Universal320312B;
import sk.singularisdev.ekasask.printer.driver.Universal320312BO;
import sk.singularisdev.ekasask.printer.driver.Universal320312BQ;
import sk.singularisdev.ekasask.printer.driver.Universal320312BQO;

public class SetPrinterType
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetPrinterType.class.getName());
    private String password;
    private int printerType;
    private int printerBaud;

    public SetPrinterType(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block58: {
            byte status;
            block59: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block58;
                    status = this.parseParams();
                    if (status != 0) break block59;
                    try {
                        Setup setup = Setup.getInstance();
                        SetupItemPrinterType printer = SetupItemPrinterType.getInstance();
                        SetupItemPrinterBaudrate baudrate = SetupItemPrinterBaudrate.getInstance();
                        switch (this.printerType) {
                            case 0: {
                                printer.setPrinterType(SRP350N.class.getName());
                                fm.setCharCount(SRP350N.getInstance().getCharPerRow());
                                break;
                            }
                            case 1: {
                                printer.setPrinterType(SRPN350.class.getName());
                                fm.setCharCount(SRPN350.getInstance().getCharPerRow());
                                break;
                            }
                            case 9: {
                                printer.setPrinterType(TMT88V.class.getName());
                                fm.setCharCount(TMT88V.getInstance().getCharPerRow());
                                break;
                            }
                            case 22: {
                                printer.setPrinterType(PCPOS1_80.class.getName());
                                fm.setCharCount(PCPOS1_80.getInstance().getCharPerRow());
                                break;
                            }
                            case 25: {
                                printer.setPrinterType(PCPOS1_57.class.getName());
                                fm.setCharCount(PCPOS1_57.getInstance().getCharPerRow());
                                break;
                            }
                            case 33: {
                                printer.setPrinterType(SRP350IIN.class.getName());
                                fm.setCharCount(SRP350IIN.getInstance().getCharPerRow());
                                break;
                            }
                            case 34: {
                                printer.setPrinterType(RONGTA80.class.getName());
                                fm.setCharCount(RONGTA80.getInstance().getCharPerRow());
                                break;
                            }
                            case 35: {
                                printer.setPrinterType(MarkEETa.class.getName());
                                fm.setCharCount(MarkEETa.getInstance().getCharPerRow());
                                break;
                            }
                            case 36: {
                                printer.setPrinterType(Modulino.class.getName());
                                fm.setCharCount(Modulino.getInstance().getCharPerRow());
                                break;
                            }
                            case 37: {
                                printer.setPrinterType(SunmiN.class.getName());
                                fm.setCharCount(SunmiN.getInstance().getCharPerRow());
                                break;
                            }
                            case 38: {
                                printer.setPrinterType(Gimex.class.getName());
                                fm.setCharCount(Gimex.getInstance().getCharPerRow());
                                break;
                            }
                            case 39: {
                                printer.setPrinterType(Modulino32.class.getName());
                                fm.setCharCount(Modulino32.getInstance().getCharPerRow());
                                break;
                            }
                            case 40: {
                                printer.setPrinterType(SRPN350II.class.getName());
                                fm.setCharCount(SRPN350II.getInstance().getCharPerRow());
                                break;
                            }
                            case 41: {
                                printer.setPrinterType(SPPR310.class.getName());
                                fm.setCharCount(SPPR310.getInstance().getCharPerRow());
                                break;
                            }
                            case 42: {
                                printer.setPrinterType(Sam4S.class.getName());
                                fm.setCharCount(Sam4S.getInstance().getCharPerRow());
                                break;
                            }
                            case 43: {
                                printer.setPrinterType(SPPR410.class.getName());
                                fm.setCharCount(SPPR410.getInstance().getCharPerRow());
                                break;
                            }
                            case 44: {
                                printer.setPrinterType(TMH6000.class.getName());
                                fm.setCharCount(TMH6000.getInstance().getCharPerRow());
                                break;
                            }
                            case 45: {
                                printer.setPrinterType(TMT88III.class.getName());
                                fm.setCharCount(TMT88III.getInstance().getCharPerRow());
                                break;
                            }
                            case 46: {
                                printer.setPrinterType(TMT20IIA.class.getName());
                                fm.setCharCount(TMT20IIA.getInstance().getCharPerRow());
                                break;
                            }
                            case 47: {
                                printer.setPrinterType(TMT20IIB.class.getName());
                                fm.setCharCount(TMT20IIB.getInstance().getCharPerRow());
                                break;
                            }
                            case 50: {
                                printer.setPrinterType(Universal218012B.class.getName());
                                fm.setCharCount(Universal218012B.getInstance().getCharPerRow());
                                break;
                            }
                            case 51: {
                                printer.setPrinterType(Universal218012BO.class.getName());
                                fm.setCharCount(Universal218012BO.getInstance().getCharPerRow());
                                break;
                            }
                            case 52: {
                                printer.setPrinterType(Universal218012BQ.class.getName());
                                fm.setCharCount(Universal218012BQ.getInstance().getCharPerRow());
                                break;
                            }
                            case 53: {
                                printer.setPrinterType(Universal218012BQO.class.getName());
                                fm.setCharCount(Universal218012BQO.getInstance().getCharPerRow());
                                break;
                            }
                            case 54: {
                                printer.setPrinterType(Universal220312B.class.getName());
                                fm.setCharCount(Universal220312B.getInstance().getCharPerRow());
                                break;
                            }
                            case 55: {
                                printer.setPrinterType(Universal220312BO.class.getName());
                                fm.setCharCount(Universal220312BO.getInstance().getCharPerRow());
                                break;
                            }
                            case 56: {
                                printer.setPrinterType(Universal220312BQ.class.getName());
                                fm.setCharCount(Universal220312BQ.getInstance().getCharPerRow());
                                break;
                            }
                            case 57: {
                                printer.setPrinterType(Universal220312BQO.class.getName());
                                fm.setCharCount(Universal220312BQO.getInstance().getCharPerRow());
                                break;
                            }
                            case 58: {
                                printer.setPrinterType(Universal318012A.class.getName());
                                fm.setCharCount(Universal318012A.getInstance().getCharPerRow());
                                break;
                            }
                            case 59: {
                                printer.setPrinterType(Universal318012AO.class.getName());
                                fm.setCharCount(Universal318012AO.getInstance().getCharPerRow());
                                break;
                            }
                            case 60: {
                                printer.setPrinterType(Universal318012AQ.class.getName());
                                fm.setCharCount(Universal318012AQ.getInstance().getCharPerRow());
                                break;
                            }
                            case 61: {
                                printer.setPrinterType(Universal318012AQO.class.getName());
                                fm.setCharCount(Universal318012AQO.getInstance().getCharPerRow());
                                break;
                            }
                            case 62: {
                                printer.setPrinterType(Universal318012B.class.getName());
                                fm.setCharCount(Universal318012B.getInstance().getCharPerRow());
                                break;
                            }
                            case 63: {
                                printer.setPrinterType(Universal318012BO.class.getName());
                                fm.setCharCount(Universal318012BO.getInstance().getCharPerRow());
                                break;
                            }
                            case 64: {
                                printer.setPrinterType(Universal318012BQ.class.getName());
                                fm.setCharCount(Universal318012BQ.getInstance().getCharPerRow());
                                break;
                            }
                            case 65: {
                                printer.setPrinterType(Universal318012BQO.class.getName());
                                fm.setCharCount(Universal318012BQO.getInstance().getCharPerRow());
                                break;
                            }
                            case 66: {
                                printer.setPrinterType(Universal320312A.class.getName());
                                fm.setCharCount(Universal320312A.getInstance().getCharPerRow());
                                break;
                            }
                            case 67: {
                                printer.setPrinterType(Universal320312AO.class.getName());
                                fm.setCharCount(Universal320312AO.getInstance().getCharPerRow());
                                break;
                            }
                            case 68: {
                                printer.setPrinterType(Universal320312AQ.class.getName());
                                fm.setCharCount(Universal320312AQ.getInstance().getCharPerRow());
                                break;
                            }
                            case 69: {
                                printer.setPrinterType(Universal320312AQO.class.getName());
                                fm.setCharCount(Universal320312AQO.getInstance().getCharPerRow());
                                break;
                            }
                            case 70: {
                                printer.setPrinterType(Universal320312B.class.getName());
                                fm.setCharCount(Universal320312B.getInstance().getCharPerRow());
                                break;
                            }
                            case 71: {
                                printer.setPrinterType(Universal320312BO.class.getName());
                                fm.setCharCount(Universal320312BO.getInstance().getCharPerRow());
                                break;
                            }
                            case 72: {
                                printer.setPrinterType(Universal320312BQ.class.getName());
                                fm.setCharCount(Universal320312BQ.getInstance().getCharPerRow());
                                break;
                            }
                            case 73: {
                                printer.setPrinterType(Universal320312BQO.class.getName());
                                fm.setCharCount(Universal320312BQO.getInstance().getCharPerRow());
                                break;
                            }
                            case 101: {
                                printer.setPrinterType(PegasinoFTN.class.getName());
                                fm.setCharCount(PegasinoFTN.getInstance().getCharPerRow());
                                break;
                            }
                            case 102: {
                                printer.setPrinterType(BL112N.class.getName());
                                fm.setCharCount(BL112N.getInstance().getCharPerRow());
                                break;
                            }
                            default: {
                                printer.setPrinterType(SRP350N.class.getName());
                                fm.setCharCount(SRP350N.getInstance().getCharPerRow());
                            }
                        }
                        if (this.printerBaud > 4) {
                            baudrate.setBaudrate(this.printerBaud);
                        } else {
                            baudrate.setBaudrate(Baudrate.fromFmId(this.printerBaud).getBaudrate());
                        }
                        setup.addItem((SetupItemInterface)printer);
                        setup.addItem((SetupItemInterface)baudrate);
                        ppekk.process((AbstractCommand)setup);
                        fm.setPrinterType(this.printerType);
                        if (this.printerBaud > 4) {
                            fm.setPrinterBaud(this.printerBaud);
                        } else {
                            fm.setPrinterBaud(Baudrate.fromFmId(this.printerBaud).getBaudrate());
                        }
                    }
                    catch (EKasaException e) {
                        System.out.println("PPEKK ERR: " + e.getErrorCode());
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        block14: {
            FmFiscalMemory fm;
            block13: {
                fm = this.eKasa.getFm();
                switch (fm.getFmState()) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    default: {
                        return 52;
                    }
                }
                if (this.params.length != 3) {
                    return 32;
                }
                try {
                    this.password = Formatter.get().getMD5Format(this.params[0]);
                    if (this.params[0].length() >= 6 && this.params[0].length() <= 8) break block13;
                    return 96;
                }
                catch (NumberFormatException e) {
                    return 96;
                }
            }
            if (this.password.equals(fm.getPassword())) break block14;
            return 49;
        }
        this.printerType = Integer.parseInt(this.params[1]);
        switch (this.printerType) {
            case 0: 
            case 1: 
            case 9: 
            case 22: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 101: 
            case 102: {
                break;
            }
            default: {
                return 96;
            }
        }
        this.printerBaud = Integer.parseInt(this.params[2]);
        if (!(this.printerBaud >= 0 && this.printerBaud <= 8 || this.printerBaud >= 40 && this.printerBaud <= 1200)) {
            return 96;
        }
        return 0;
    }
}

