/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetSMTP
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetSMTP.class.getName());
    private int smtpType;
    private int PORT;
    private String IP;
    private String localDIR;

    public SetSMTP(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        if (fm.isDbOk()) {
            byte status = this.parseParams();
            if (status == 0) {
                try {
                    fm.setEmailDirectory(this.localDIR);
                }
                catch (FmStoreToDbException e) {
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        block12: {
            block11: {
                block10: {
                    FmFiscalMemory fm = this.eKasa.getFm();
                    switch (fm.getFmState()) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            return 52;
                        }
                    }
                    if (this.params.length != 4) {
                        return 32;
                    }
                    try {
                        this.smtpType = Integer.parseInt(this.params[0]);
                        if (this.smtpType == 1) break block10;
                        return 96;
                    }
                    catch (NumberFormatException e) {
                        return 96;
                    }
                }
                this.IP = this.params[1];
                if (this.IP.length() <= 40) break block11;
                return 96;
            }
            this.PORT = Integer.parseInt(this.params[2]);
            if (this.PORT >= 0 && this.PORT <= 99999) break block12;
            return 96;
        }
        this.localDIR = this.params[3];
        if (this.localDIR.length() > 255) {
            return 96;
        }
        return 0;
    }
}

